/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.template.editor.common.Changeset;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.esl.template.editor.model.XSLTag;
import at.mrdevelopment.esl.template.editor.model.XSLTextOption;
import at.mrdevelopment.toolkit.barcode.Barcode;
import at.mrdevelopment.toolkit.barcode.BarcodeException;
import at.mrdevelopment.toolkit.barcode.BarcodeFactory;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.options.StringChoiceOption;
import at.mrdevelopment.toolkit.tree.Path;
import at.mrdevelopment.toolkit.tree.TreeException;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class XSLBarcodeField
extends XSLTag {
    public static final String TYPE = "barcode";
    public static final String OPTION_CONTAINER_NAME = "barcodeOptions";
    public static final String OPTION_CONTAINER_PRINT_NAME = "Barcode Options";
    public static final String BARCODE_CODE_OPTION_KEY = "barcodeCode";
    public static final String BARCODE_TYPE_OPTION_KEY = "type";
    private BarcodeFactory barcodeFactory = new BarcodeFactory();
    private Barcode barcode;
    private static final String DEFAULT_BARCODE_TYPE = "ean13";

    public XSLBarcodeField(int fieldId, Element barcodeElement, DesignTemplateModel templateModel) throws OptionException, BarcodeException, TreeException {
        super(fieldId, barcodeElement, templateModel, OPTION_CONTAINER_NAME, OPTION_CONTAINER_PRINT_NAME, new TemplateNode[]{TemplateNode.BARCODE});
        this.init();
    }

    private void init() throws OptionException, BarcodeException, TreeException {
        for (Option<?> option : this.getOptionList()) {
            if (!option.getKey().equals(BARCODE_TYPE_OPTION_KEY)) continue;
            this.unregisterOption(option);
            this.getOptionList().remove(option);
            break;
        }
        String barcodeType = DEFAULT_BARCODE_TYPE;
        if (this.getTagElement().hasAttribute(BARCODE_TYPE_OPTION_KEY)) {
            barcodeType = this.getTagElement().getAttribute(BARCODE_TYPE_OPTION_KEY);
        }
        this.registerOption(new StringChoiceOption(BARCODE_TYPE_OPTION_KEY, null, this.barcodeFactory.getBarcodeIdentifiers()));
        this.setOption(BARCODE_TYPE_OPTION_KEY, barcodeType, new Changeset());
        this.registerOption("text", new XSLTextOption("", this.getXSLElement()));
        if (this.getTagElement().getTextContent() != null && !this.getTagElement().getTextContent().isEmpty()) {
            this.setOption("text", this.getTagElement().getTextContent(), new Changeset());
        }
        this.initBarcode(this.getOptionValue(BARCODE_TYPE_OPTION_KEY));
    }

    private void initBarcode(String barcodeType) throws OptionException, BarcodeException {
        this.barcode = this.barcodeFactory.getBarcode(barcodeType);
        this.registerOptions(this.barcode.getOptionContainer());
    }

    private void setBarcodeType(String barcodeType, Changeset changeset) throws BarcodeException, OptionException, TreeException {
        ArrayList oldOptionList = new ArrayList(this.getOptionList());
        this.unregisterOptions(this.getOptionList(), changeset);
        this.barcode = this.barcodeFactory.getBarcode(barcodeType);
        String text = null;
        for (Option option : oldOptionList) {
            if (!option.getKey().equals(BARCODE_TYPE_OPTION_KEY) && this.barcode.getOptionContainer().hasOption(option.getKey())) {
                this.barcode.getOptionContainer().replaceOption(option);
            }
            if (!option.getKey().equals("text") || option.isDefault()) continue;
            text = option.getValueAsString();
        }
        for (Attribute attribute : TemplateNode.BARCODE.getAttributeList()) {
            if (attribute.getKey().equals(Attribute.BARCODE_TYPE.getKey())) continue;
            for (Option option : oldOptionList) {
                if (!attribute.getKey().equals(option.getKey())) continue;
                if (option.isDefault()) {
                    try {
                        this.registerOption(attribute.createOption());
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                    continue;
                }
                try {
                    Option<?> option2 = attribute.createOption();
                    option2.setValueFromString(option.getValueAsString());
                    this.registerOption(option2);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
        this.registerOption(new StringChoiceOption(BARCODE_TYPE_OPTION_KEY, null, this.barcodeFactory.getBarcodeIdentifiers()));
        this.setOption(BARCODE_TYPE_OPTION_KEY, DEFAULT_BARCODE_TYPE, new Changeset());
        this.registerOption("text", new XSLTextOption(text != null ? text : "", this.getXSLElement()));
        this.setOption(BARCODE_TYPE_OPTION_KEY, barcodeType, changeset);
        this.registerOptions(this.barcode.getOptionContainer());
    }

    @Override
    public void setOption(Path optionPath, String value, Changeset changeset, boolean complex) throws OptionException, TreeException {
        if (optionPath == null) {
            throw new OptionException("Option Path is null");
        }
        if (optionPath.getSize() != 1) {
            throw new OptionException("Can't set an option on this path: [" + optionPath.toString() + "]");
        }
        String optionKey = optionPath.getFirstElement();
        if (complex && optionKey.equals(BARCODE_TYPE_OPTION_KEY)) {
            try {
                this.setBarcodeType(value, changeset);
                return;
            }
            catch (BarcodeException e) {
                throw new OptionException(e);
            }
        }
        this.setOption(optionKey, value, changeset);
    }

    @Override
    public boolean isComprehensible() {
        return true;
    }

    @Override
    protected void unregisterOptionsRecursively(Changeset changeset) throws OptionException, TreeException {
        this.unregisterOptions(changeset);
    }
}

