/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.template.editor.model.TemplateModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

public class XMLTreeEntry
implements TreeNode {
    private static final String PREFIX = "/Record/";
    private String value;
    private final String path;
    private final String nodeName;
    private List<TreeNode> childNodes;
    private XMLTreeEntry parent;
    private final TemplateModel model;

    public XMLTreeEntry(XMLTreeEntry parent, String nodeName, String path, String value, TemplateModel model) {
        this.model = model;
        this.parent = parent;
        this.nodeName = nodeName;
        this.path = path;
        this.value = value;
        this.childNodes = new ArrayList<TreeNode>();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.childNodes.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.childNodes.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.childNodes.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return this.getChildCount() > 0;
    }

    @Override
    public boolean isLeaf() {
        return !this.getAllowsChildren();
    }

    public Enumeration children() {
        return Collections.enumeration(this.childNodes);
    }

    public String getValue() {
        return this.value;
    }

    public String compile(DOMSource source) throws XPathExpressionException {
        return XPathFactory.newInstance().newXPath().compile(PREFIX + this.getPath()).evaluate(source.getNode());
    }

    public String getPath() {
        return this.path;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String toString() {
        String value = "";
        try {
            value = this.compile(this.model.getRecordSource());
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return this.getChildCount() == 0 && this.getValue() != null && !this.getValue().isEmpty() ? String.format("%s (%s)", this.getNodeName(), value) : this.getNodeName();
    }

    public void addChild(XMLTreeEntry childNode) {
        this.childNodes.add(childNode);
    }

    public void deleteValue() {
        this.value = null;
    }
}

