/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.WebserviceDatasetRegistry;
import at.mrdevelopment.esl.persistence.dataset.PagedDataset;
import at.mrdevelopment.esl.persistence.record.ArticleRecord;
import at.mrdevelopment.esl.service.ServiceClient;
import at.mrdevelopment.esl.template.editor.model.TemplateModel;
import at.mrdevelopment.esl.template.editor.model.XMLRecord;
import at.mrdevelopment.esl.template.editor.model.XMLRecordContainerListener;
import at.mrdevelopment.esl.template.editor.model.XMLRecordInterface;
import at.mrdevelopment.esl.template.editor.model.XMLRecordsContainer;
import at.mrdevelopment.esl.type.Article;
import at.mrdevelopment.esl.xml.ArticleXMLSerializer;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.gui.RecordsPerPage;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class XMLServerRecordsContainer
implements XMLRecordsContainer {
    static ESLLogger logger = ESLLogger.getLogger(XMLServerRecordsContainer.class);
    private TemplateModel templateModel;
    private int currentIndex = 0;
    private int totalRecords = 0;
    private XMLRecord currentRecord;
    private Map<Integer, XMLRecord> records;
    private final HashSet<XMLRecordContainerListener> listeners;
    private final ServiceClient client;
    private final WebserviceDatasetRegistry datasetRegistry;
    private final PagedDataset<ArticleRecord> pagedDataset;
    private final ArticleXMLSerializer articleXMLSerializer;
    private Map<Integer, String> articleToIdMapping = new HashMap<Integer, String>();

    public XMLServerRecordsContainer(ServiceAddress serviceAddress, TemplateModel templateModel) throws InitializationException {
        this.records = new HashMap<Integer, XMLRecord>();
        this.client = new ServiceClient(serviceAddress.getHost(), serviceAddress.getPort(), serviceAddress.useSSL());
        this.client.setCredentials("admin", "admin");
        this.articleXMLSerializer = new ArticleXMLSerializer();
        try {
            this.client.queryServiceStatus();
        }
        catch (Exception exc) {
            throw new InitializationException(exc);
        }
        if (!this.client.hasRecordClassRegistered(ArticleRecord.class)) {
            throw new InitializationException("The server does not support articles", new Object[0]);
        }
        this.datasetRegistry = new WebserviceDatasetRegistry(this.client.getHttpServiceClient());
        this.datasetRegistry.registerDataset(ArticleRecord.class, this.client.getCustomFields(ArticleRecord.class));
        this.pagedDataset = this.datasetRegistry.getPagedDataset(ArticleRecord.class);
        try {
            this.pagedDataset.setRecordsPerPage(RecordsPerPage.SINGLE);
        }
        catch (DatasetException exc) {
            throw new InitializationException(exc);
        }
        this.templateModel = templateModel;
        this.listeners = new HashSet();
        this.reload();
    }

    private void reload() {
        try {
            this.pagedDataset.reload().waitUntilFinished();
            this.pagedDataset.selectPage(this.currentIndex);
            this.pagedDataset.reload().waitUntilFinished();
            this.totalRecords = this.pagedDataset.getPageCount();
            ArticleRecord articleRecord = (ArticleRecord)this.pagedDataset.getRecord(0);
            Article article = articleRecord.toArticle();
            this.currentRecord = new XMLRecord(this.createId(article), this.articleXMLSerializer.toXML(article), false);
            this.articleToIdMapping.put(this.currentIndex, this.currentRecord.getId());
            this.records.put(this.currentIndex, this.currentRecord);
        }
        catch (Exception exc) {
            logger.warn(exc.getMessage());
            logger.logExceptionIfDebugEnabled(exc);
            this.templateModel.addExecutionStatus(new ExceptionElement(exc));
        }
    }

    private String createId(Article article) {
        return String.format("%s (%s:%d)", article.getArticleNumber().toString(), this.client.getHttpServiceClient().getHost(), this.client.getHttpServiceClient().getPort());
    }

    private void notifyRecordListeners(XMLRecord record) {
        for (XMLRecordContainerListener listener : this.listeners) {
            listener.recordAdded(record.getId());
        }
    }

    @Override
    public void addRecordListener(XMLRecordContainerListener listener) {
        this.listeners.add(listener);
        this.notifyRecordListeners(this.currentRecord);
    }

    @Override
    public boolean closeAllRecords() {
        return false;
    }

    @Override
    public boolean closeCurrentRecord() {
        return false;
    }

    public boolean canSaveCurrentRecord() {
        return false;
    }

    public boolean isCurrentRecordModified() {
        return false;
    }

    @Override
    public boolean saveCurrentRecord() {
        return false;
    }

    @Override
    public boolean saveAllRecords() {
        return false;
    }

    @Override
    public XMLRecordInterface getCurrentRecord() {
        return this.currentRecord;
    }

    @Override
    public int getCurrentRecordIndex() {
        return this.currentIndex;
    }

    @Override
    public int getTotalRecordsCount() {
        return this.totalRecords;
    }

    @Override
    public XMLRecordInterface getNextRecord() {
        if (this.hasNextRecord()) {
            ++this.currentIndex;
            this.updateRecord();
            return this.currentRecord;
        }
        return null;
    }

    @Override
    public XMLRecordInterface getFirstRecord() {
        if (this.hasPreviousRecord()) {
            this.currentIndex = 0;
            this.updateRecord();
            return this.currentRecord;
        }
        return null;
    }

    @Override
    public XMLRecordInterface getLastRecord() {
        if (this.hasNextRecord()) {
            this.currentIndex = this.getTotalRecordsCount() - 1;
            this.updateRecord();
            return this.currentRecord;
        }
        return null;
    }

    private void updateRecord() {
        if (this.isRecordsWithIndexLoaded(this.currentIndex)) {
            this.updateCurrentRecord();
        } else {
            this.reload();
        }
    }

    @Override
    public XMLRecordInterface getPreviousRecord() {
        if (this.hasPreviousRecord()) {
            --this.currentIndex;
            this.updateRecord();
            return this.currentRecord;
        }
        return null;
    }

    private void updateCurrentRecord() {
        this.currentRecord = this.records.get(new Integer(this.currentIndex));
    }

    private boolean isRecordsWithIndexLoaded(int index) {
        return this.records.containsKey(new Integer(index));
    }

    @Override
    public boolean hasNextRecord() {
        return this.currentIndex + 1 >= 0 && this.currentIndex + 1 < this.getTotalRecordsCount();
    }

    @Override
    public boolean hasPreviousRecord() {
        return this.currentIndex - 1 >= 0 && this.currentIndex - 1 < this.getTotalRecordsCount();
    }

    @Override
    public boolean hasRecords() {
        return this.getTotalRecordsCount() > 0;
    }

    @Override
    public boolean hasRecord(String id) {
        return this.articleToIdMapping.containsValue(id);
    }

    @Override
    public Collection<XMLRecordInterface> getAllRecords() {
        ArrayList<XMLRecord> interfaceRecords = new ArrayList<XMLRecord>();
        for (int i = 0; i < this.getTotalRecordsCount(); ++i) {
            if (this.isRecordsWithIndexLoaded(i)) {
                interfaceRecords.add(this.records.get(i));
                continue;
            }
            try {
                this.pagedDataset.selectPage(i);
                this.pagedDataset.reload().waitUntilFinished();
                Article article = ((ArticleRecord)this.pagedDataset.getRecord(0)).toArticle();
                XMLRecord record = new XMLRecord(this.createId(article).toString(), this.articleXMLSerializer.toXML(article), false);
                interfaceRecords.add(record);
                this.articleToIdMapping.put(i, record.getId());
                this.records.put(i, record);
                continue;
            }
            catch (Exception exc) {
                logger.warn(exc.getMessage());
                logger.logExceptionIfDebugEnabled(exc);
                this.templateModel.addExecutionStatus(new ExceptionElement(exc));
            }
        }
        this.updateRecord();
        return Collections.unmodifiableCollection(interfaceRecords);
    }

    @Override
    public boolean closeRecord(XMLRecordInterface record) {
        return true;
    }

    @Override
    public XMLRecordInterface setRecordSelected(String identifier) {
        for (Map.Entry<Integer, String> entry : this.articleToIdMapping.entrySet()) {
            if (!entry.getValue().equals(identifier)) continue;
            this.currentIndex = entry.getKey();
            this.updateRecord();
            return this.currentRecord;
        }
        return null;
    }

    @Override
    public void removeRecord(XMLRecordInterface record) {
    }

    @Override
    public Collection<XMLRecordContainerListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void reloadCurrentRecord() {
        this.reload();
    }
}

