/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.template.editor.model.TemplateModel;
import at.mrdevelopment.esl.template.editor.model.XMLTreeEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLRecordSource {
    private Element xmlRecordElement;
    private Map<String, Map<String, String>> entries = new HashMap<String, Map<String, String>>();
    private Map<String, String> records = new HashMap<String, String>();
    private XMLTreeEntry rootTreeNode;
    private TemplateModel model;

    public XMLRecordSource(Element xmlRecordElement, TemplateModel model) {
        this.xmlRecordElement = xmlRecordElement;
        this.model = model;
        this.rootTreeNode = new XMLTreeEntry(null, xmlRecordElement.getNodeName(), "", "", model);
        this.parseEntries(0, "", xmlRecordElement, this.rootTreeNode);
    }

    public List<String> getEntryKeys() {
        ArrayList<String> entryKeyList = new ArrayList<String>();
        entryKeyList.addAll(this.records.keySet());
        Collections.sort(entryKeyList);
        return entryKeyList;
    }

    public DOMSource getDOMSource() {
        return new DOMSource(this.xmlRecordElement.cloneNode(true));
    }

    public Map<String, Map<String, String>> getEntries() {
        return this.entries;
    }

    private Element createElement(String name) {
        return this.xmlRecordElement.getOwnerDocument().createElement(name);
    }

    public void updateRecordElement() {
        Document ownerDocument = this.xmlRecordElement.getOwnerDocument();
        ownerDocument.removeChild(ownerDocument.getDocumentElement());
        this.xmlRecordElement = ownerDocument.createElement("Record");
        NodeList childNodes = this.xmlRecordElement.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            this.xmlRecordElement.removeChild(childNodes.item(index));
        }
        for (String entryKey : this.entries.keySet()) {
            Element entryElement = this.createElement(entryKey);
            for (String subEntryKey : this.entries.get(entryKey).keySet()) {
                Element subEntryElement = this.createElement(subEntryKey);
                subEntryElement.setTextContent(this.entries.get(entryKey).get(subEntryKey));
                entryElement.appendChild(subEntryElement);
            }
            this.xmlRecordElement.appendChild(entryElement);
        }
        ownerDocument.appendChild(this.xmlRecordElement);
    }

    private void parseEntries(int depth, String parentString, Element element, XMLTreeEntry treeNode) {
        NodeList entryNodes = element.getChildNodes();
        ++depth;
        for (int index = 0; index < entryNodes.getLength(); ++index) {
            if (!(entryNodes.item(index) instanceof Element)) continue;
            Element childElement = (Element)entryNodes.item(index);
            String path = null;
            path = parentString.isEmpty() ? childElement.getNodeName() : parentString + "/" + childElement.getNodeName();
            NamedNodeMap attributes = childElement.getAttributes();
            HashMap<String, String> attributeMap = new HashMap<String, String>();
            for (int attributeIndex = 0; attributeIndex < attributes.getLength(); ++attributeIndex) {
                Node attribute = attributes.item(attributeIndex);
                attributeMap.put(attribute.getNodeName(), attribute.getNodeValue());
            }
            this.records.put(path, childElement.getTextContent());
            String textContent = StringUtils.normalizeSpace((String)childElement.getTextContent());
            int similarElementCount = element.getElementsByTagName(childElement.getNodeName()).getLength();
            XMLTreeEntry childNode = null;
            if (similarElementCount > 1) {
                path = String.format("%s[%d]", path, this.getChildPosition(element, childElement));
                childNode = new XMLTreeEntry(treeNode, childElement.getNodeName(), path, textContent, this.model);
            } else {
                childNode = new XMLTreeEntry(treeNode, childElement.getNodeName(), path, textContent, this.model);
            }
            boolean textContentEntriesAdded = false;
            for (Map.Entry entry : attributeMap.entrySet()) {
                if (similarElementCount == 1) {
                    childNode.addChild(new XMLTreeEntry(childNode, (String)entry.getKey(), path + "/@" + (String)entry.getKey(), (String)entry.getValue(), this.model));
                    continue;
                }
                for (Map.Entry subEntry : attributeMap.entrySet()) {
                    if (((Object)entry).equals(subEntry)) continue;
                    childNode.addChild(new XMLTreeEntry(childNode, (String)entry.getKey(), String.format("%s[@%s = '%s']/@%s", path, entry.getKey(), entry.getValue(), subEntry.getKey()), (String)entry.getValue(), this.model));
                    if (textContent == null || textContent.isEmpty()) continue;
                    childNode.addChild(new XMLTreeEntry(childNode, childElement.getNodeName(), String.format("%s[@%s = '%s']/%s", path, entry.getKey(), entry.getValue(), childElement.getNodeName()), textContent, this.model));
                    textContentEntriesAdded = true;
                }
            }
            if (childNode.getChildCount() > 0) {
                childNode.deleteValue();
                if (!textContentEntriesAdded && textContent != null && !textContent.isEmpty()) {
                    childNode.addChild(new XMLTreeEntry(childNode, childElement.getNodeName(), path, textContent, this.model));
                }
            }
            treeNode.addChild(childNode);
            if (!childElement.hasChildNodes() || !this.containsElement(childElement)) continue;
            this.parseEntries(depth, path, childElement, childNode);
        }
    }

    private int getChildPosition(Element element, Element childElement) {
        NodeList nodeList = element.getElementsByTagName(childElement.getNodeName());
        for (int index = 0; index < nodeList.getLength(); ++index) {
            if (!nodeList.item(index).equals(childElement)) continue;
            return index + 1;
        }
        return 1;
    }

    private boolean containsElement(Node node) {
        NodeList childNodes = node.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            if (!(childNodes.item(index) instanceof Element)) continue;
            return true;
        }
        return false;
    }

    public TreeNode getRootTreeNode() {
        return this.rootTreeNode;
    }
}

