/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.template.editor.common.TemplateEditorPreferences;
import at.mrdevelopment.esl.template.editor.model.TemplateModel;
import at.mrdevelopment.esl.template.editor.model.XMLFileRecord;
import at.mrdevelopment.esl.template.editor.model.XMLRecordContainerListener;
import at.mrdevelopment.esl.template.editor.model.XMLRecordInterface;
import at.mrdevelopment.esl.template.editor.model.XMLRecordsContainer;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StringElement;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;

public class XMLFileRecordsContainer
implements XMLRecordsContainer {
    public static final String DEFAULT_RECORD_NAME = "untitled";
    private LinkedList<XMLFileRecord> records;
    private TemplateModel templateModel;
    private final XMLToolkit xmlToolkit;
    private int currentIndex = -1;
    private TemplateEditorPreferences preferences;
    private HashSet<XMLRecordContainerListener> listeners;

    public XMLFileRecordsContainer(TemplateModel templateModel, TemplateEditorPreferences preferences) throws InitializationException {
        this.templateModel = templateModel;
        this.preferences = preferences;
        this.records = new LinkedList();
        this.xmlToolkit = new XMLToolkit();
        this.listeners = new HashSet();
    }

    @Override
    public void addRecordListener(XMLRecordContainerListener listener) {
        this.listeners.add(listener);
    }

    public void notifyRecordAdded(String id) {
        for (XMLRecordContainerListener listener : this.listeners) {
            listener.recordAdded(id);
        }
    }

    private void notifyRecordRemoved(String id) {
        for (XMLRecordContainerListener listener : this.listeners) {
            listener.recordRemoved(id);
        }
    }

    private void notifyAllRecordsRemoved() {
        for (XMLRecordContainerListener listener : this.listeners) {
            listener.allRecordsRemoved();
        }
    }

    public void addRecord(String fileName, boolean ignorePreferences, boolean notify) {
        for (XMLFileRecord record : this.records) {
            if (!record.getFileName().equals(fileName)) continue;
            this.templateModel.addExecutionStatus(new StringElement(String.format("XML Record already opened (%s)", fileName), ExecutionStatusElement.ErrorLevel.WARNING));
            return;
        }
        try {
            XMLFileRecord record = new XMLFileRecord(fileName, this.templateModel, false);
            this.records.add(record);
            this.currentIndex = this.records.size() - 1;
            if (!ignorePreferences) {
                this.preferences.addRecentRecord(new File(fileName));
            }
            if (notify) {
                this.notifyRecordAdded(record.getId());
            }
        }
        catch (Exception exc) {
            this.templateModel.addExecutionStatus(new ExceptionElement(exc));
        }
    }

    public void addRecord(String fileName) {
        this.addRecord(fileName, false, true);
    }

    public void addRecordWithoutNotification(String fileName, boolean ignorePreferences) {
        this.addRecord(fileName, ignorePreferences, false);
    }

    public void addNewRecord() {
        try {
            XMLFileRecord record = new XMLFileRecord(DEFAULT_RECORD_NAME, this.xmlToolkit.newDocument());
            this.records.add(record);
            this.currentIndex = this.records.size() - 1;
            this.notifyRecordAdded(record.getId());
        }
        catch (Exception exc) {
            this.templateModel.addExecutionStatus(new ExceptionElement(exc));
        }
    }

    @Override
    public boolean closeAllRecords() {
        this.records.clear();
        this.currentIndex = -1;
        this.notifyAllRecordsRemoved();
        return true;
    }

    @Override
    public boolean closeCurrentRecord() {
        if (this.currentIndex >= 0 && this.currentIndex < this.records.size()) {
            XMLFileRecord record = this.records.get(this.currentIndex);
            if (this.currentIndex == this.records.size()) {
                --this.currentIndex;
            }
            return this.closeRecord(record);
        }
        return false;
    }

    public boolean canSaveCurrentRecord() {
        if (this.getCurrentRecord() != null) {
            return ((XMLFileRecord)this.getCurrentRecord()).canSave();
        }
        return false;
    }

    public boolean isShowSaveAsCurrentRecord() {
        if (this.getCurrentRecord() != null) {
            return ((XMLFileRecord)this.getCurrentRecord()).isShowSaveAs();
        }
        return false;
    }

    public boolean isCurrentRecordModified() {
        if (this.getCurrentRecord() != null) {
            return ((XMLFileRecord)this.getCurrentRecord()).isModified();
        }
        return false;
    }

    @Override
    public boolean saveCurrentRecord() {
        XMLRecordInterface currentRecord = this.getCurrentRecord();
        if (currentRecord != null) {
            return this.saveRecord((XMLFileRecord)currentRecord);
        }
        return false;
    }

    private boolean saveRecord(XMLFileRecord record) {
        try {
            record.saveRecord();
            return true;
        }
        catch (Exception exc) {
            this.templateModel.addExecutionStatus(new ExceptionElement(exc));
            return false;
        }
    }

    @Override
    public boolean saveAllRecords() {
        boolean returnValue = true;
        for (XMLFileRecord record : this.records) {
            returnValue = this.saveRecord(record) ? returnValue : false;
        }
        return returnValue;
    }

    @Override
    public XMLRecordInterface getCurrentRecord() {
        if (this.currentIndex >= 0 && this.currentIndex < this.records.size()) {
            return this.records.get(this.currentIndex);
        }
        return null;
    }

    @Override
    public int getCurrentRecordIndex() {
        return this.currentIndex;
    }

    @Override
    public int getTotalRecordsCount() {
        return this.records.size();
    }

    @Override
    public XMLRecordInterface getNextRecord() {
        if (this.hasNextRecord()) {
            ++this.currentIndex;
            return this.records.get(this.currentIndex);
        }
        return null;
    }

    @Override
    public XMLRecordInterface getFirstRecord() {
        if (this.hasPreviousRecord()) {
            this.currentIndex = 0;
            return this.records.get(this.currentIndex);
        }
        return null;
    }

    @Override
    public XMLRecordInterface getLastRecord() {
        if (this.hasNextRecord()) {
            this.currentIndex = this.records.size() - 1;
            return this.records.get(this.currentIndex);
        }
        return null;
    }

    @Override
    public XMLRecordInterface getPreviousRecord() {
        if (this.hasPreviousRecord()) {
            --this.currentIndex;
            return this.records.get(this.currentIndex);
        }
        return null;
    }

    @Override
    public boolean hasNextRecord() {
        return this.currentIndex + 1 >= 0 && this.currentIndex + 1 < this.records.size();
    }

    @Override
    public boolean hasPreviousRecord() {
        return this.currentIndex - 1 >= 0 && this.currentIndex - 1 < this.records.size();
    }

    @Override
    public boolean hasRecords() {
        return this.records.size() > 0;
    }

    @Override
    public boolean hasRecord(String id) {
        for (XMLFileRecord record : this.records) {
            if (!record.toString().equals(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<XMLRecordInterface> getAllRecords() {
        ArrayList<XMLFileRecord> interfaceRecords = new ArrayList<XMLFileRecord>();
        for (XMLFileRecord record : this.records) {
            interfaceRecords.add(record);
        }
        return Collections.unmodifiableCollection(interfaceRecords);
    }

    @Override
    public boolean closeRecord(XMLRecordInterface record) {
        XMLFileRecord fileRecord = (XMLFileRecord)record;
        this.records.remove(fileRecord);
        if (this.currentIndex == this.records.size()) {
            --this.currentIndex;
        }
        this.notifyRecordRemoved(record.getId());
        return true;
    }

    @Override
    public XMLRecordInterface setRecordSelected(String identifier) {
        for (XMLFileRecord record : this.records) {
            if (!record.getId().equals(identifier)) continue;
            this.currentIndex = this.records.indexOf(record);
            return record;
        }
        return null;
    }

    @Override
    public void removeRecord(XMLRecordInterface record) {
        this.records.remove(record);
    }

    @Override
    public Collection<XMLRecordContainerListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void reloadCurrentRecord() {
    }
}

