/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.template.editor.model.AbstractXMLRecord;
import at.mrdevelopment.esl.template.editor.model.TemplateModel;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.XMLContentProducerFactory;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLFileRecord
extends AbstractXMLRecord {
    private String fileName;
    private boolean initialModifiedState;

    public XMLFileRecord(String dummyName, Document document) throws SerializeException, IOException {
        super(document, XMLContentProducerFactory.newInstance().toString(document), true);
        this.fileName = dummyName;
        this.initialModifiedState = true;
    }

    public XMLFileRecord(String fileName, TemplateModel templateModel, boolean initialModifiedState) throws FileNotFoundException, SerializeException, InitializationException, IOException {
        super(XMLFileRecord.loadRecordElement(fileName).getOwnerDocument(), XMLFileRecord.readFileContent(fileName), initialModifiedState);
        this.fileName = fileName;
    }

    private static String readFileContent(String fileName) throws IOException {
        return FileUtils.readFileToString((File)new File(fileName), (String)"UTF-8");
    }

    private static Element loadRecordElement(String fileName) throws FileNotFoundException, SerializeException, InitializationException {
        XMLToolkit xmlToolKit = new XMLToolkit();
        return xmlToolKit.getDocumentRootFromFile(new File(fileName));
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void saveRecord() throws FileNotFoundException, IOException {
        super.saveRecord(this.fileName);
        this.initialModifiedState = false;
    }

    @Override
    public void saveRecord(String fileName) throws FileNotFoundException, IOException {
        this.setFileName(fileName);
        this.saveRecord();
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String getDisplayName() {
        String name = this.getFileName();
        name = name + (this.isModified() ? "*" : "");
        return name;
    }

    @Override
    public boolean isShowSaveAs() {
        return this.initialModifiedState;
    }

    @Override
    public boolean isReloadable() {
        return false;
    }
}

