/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.template.editor.model.TemplateEditorTemplates;

public enum TemplateEditorTemplate {
    TEMPLATE_EMPTY("Empty Template", "An empty template", TemplateEditorTemplates.DEFAULT_EMPTY_TEMPLATE_STRING, 0, 0),
    TEMPLATE_DYNAMIC("Dynamic Template", "A dynamic template for multiple display sizes", "", 0, 0),
    TEMPLATE_10_2("10.2\" Label Template", "A static layout for 10.2\" labels.", String.format(TemplateEditorTemplates.DEFAULT_TEMPLATE_STRING, 1024, 1280), 1024, 1280),
    TEMPLATE_7_4("7.4\" Label Template", "A static layout for 7.4\" labels.", String.format(TemplateEditorTemplates.DEFAULT_TEMPLATE_STRING, 480, 800), 480, 800),
    TEMPLATE_4_4("4.41\" Label Template", "A static layout for 4.41\" labels.", String.format(TemplateEditorTemplates.DEFAULT_TEMPLATE_STRING, 400, 300), 400, 300),
    TEMPLATE_2_7("2.7\" Label Template", "A static layout for 2.7\" labels.", String.format(TemplateEditorTemplates.DEFAULT_TEMPLATE_STRING, 264, 176), 264, 176),
    TEMPLATE_2("2\" Label Template", "A static layout for 2\" labels.", String.format(TemplateEditorTemplates.DEFAULT_TEMPLATE_STRING, 200, 96), 200, 96);

    private final String title;
    private final String description;
    private final String template;
    private final int displayWidth;
    private final int displayHeight;

    private TemplateEditorTemplate(String title, String description, String template, int displayWidth, int displayHeight) {
        this.title = title;
        this.description = description;
        this.template = template;
        this.displayWidth = displayWidth;
        this.displayHeight = displayHeight;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTemplate() {
        return this.template;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public boolean isEmpty() {
        return this == TEMPLATE_EMPTY;
    }

    public boolean isDynamic() {
        return !this.isEmpty() && (this.displayHeight <= 0 || this.displayWidth <= 0);
    }

    public String toString() {
        return this.getTitle();
    }
}

