/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.template.editor.model.TemplateModel;
import at.mrdevelopment.esl.template.editor.model.XMLRecord;
import at.mrdevelopment.esl.template.editor.model.XMLRecordSource;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.File;
import java.io.FileNotFoundException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class RecordXMLSerializer
implements XMLSerializer<XMLRecord> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public XMLRecordSource parseRecord(InputSource inputSource, TemplateModel model) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRoot(inputSource);
        return this.parseRecord(root, model);
    }

    public XMLRecordSource parseRecord(File templateFile, TemplateModel model) throws FileNotFoundException, SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromFile(templateFile);
        return this.parseRecord(root, model);
    }

    public XMLRecordSource parseRecord(DOMSource domSource, TemplateModel model) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRoot(domSource);
        return this.parseRecord(root, model);
    }

    public XMLRecordSource parseRecord(String xmlFileName, TemplateModel model) throws SerializeException, FileNotFoundException {
        Element root = this.xmlToolkit.getDocumentRootFromFile(new File(xmlFileName));
        return this.parseRecord(root, model);
    }

    private XMLRecordSource parseRecord(Element root, TemplateModel model) throws SerializeException {
        return new XMLRecordSource(root, model);
    }

    public void storeRecord(XMLRecordSource xmlRecord, String xmlFileName) throws SerializeException {
        try {
            StreamResult xmlResult = new StreamResult(new File(xmlFileName));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(xmlRecord.getDOMSource(), xmlResult);
        }
        catch (Exception exc) {
            throw new SerializeException(exc);
        }
    }
}

