/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.Status;
import at.mrdevelopment.esl.core.SyncQuality;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.type.LabelErrors;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.toolkit.Version;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.table.DefaultTableModel;
import org.joda.time.DateTime;

public class LabelInfoTableModel
extends DefaultTableModel {
    private List<LabelInfo> labelInfos = new CopyOnWriteArrayList<LabelInfo>();

    public LabelInfoTableModel(Collection<LabelInfo> labelInfos) {
        this.labelInfos.addAll(labelInfos);
    }

    @Override
    public int getRowCount() {
        return this.labelInfos == null ? 0 : this.labelInfos.size();
    }

    @Override
    public int getColumnCount() {
        return 17;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Label ID";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "Tags";
            }
            case 3: {
                return "Last Seen";
            }
            case 4: {
                return "Power";
            }
            case 5: {
                return "RSSI";
            }
            case 6: {
                return "LQI";
            }
            case 7: {
                return "Firmware";
            }
            case 8: {
                return "Sync Quality";
            }
            case 9: {
                return "Label Error";
            }
            case 10: {
                return "AP ID";
            }
            case 11: {
                return "Label Status";
            }
            case 12: {
                return "Task Type";
            }
            case 13: {
                return "Page";
            }
            case 14: {
                return "Task Status";
            }
            case 15: {
                return "Error Code";
            }
            case 16: {
                return "Task Updated At";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return LabelId.class;
            }
            case 1: {
                return LabelType.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return DateTime.class;
            }
            case 4: {
                return PowerStatus.class;
            }
            case 5: {
                return Integer.class;
            }
            case 6: {
                return Integer.class;
            }
            case 7: {
                return Version.class;
            }
            case 8: {
                return SyncQuality.class;
            }
            case 9: {
                return LabelErrors.class;
            }
            case 10: {
                return Integer.class;
            }
            case 11: {
                return ConnectionStatus.class;
            }
            case 12: {
                return TaskType.class;
            }
            case 13: {
                return Page.class;
            }
            case 14: {
                return Status.class;
            }
            case 15: {
                return UpdateError.class;
            }
            case 16: {
                return DateTime.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        LabelInfo labelInfo = this.labelInfos.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return labelInfo.getLabelId();
            }
            case 1: {
                return labelInfo.getLabelId().getLabelType();
            }
            case 2: {
                return this.createTagsString(labelInfo.getTags());
            }
            case 3: {
                return labelInfo.getLastRefreshTime();
            }
            case 4: {
                return labelInfo.getPowerStatus();
            }
            case 5: {
                return labelInfo.getRssi();
            }
            case 6: {
                return labelInfo.getLqi();
            }
            case 7: {
                return labelInfo.getFirmwareVersion();
            }
            case 8: {
                return labelInfo.getSyncQuality();
            }
            case 9: {
                return labelInfo.getLabelErrors();
            }
            case 10: {
                return labelInfo.getAccessPointId();
            }
            case 11: {
                return labelInfo.getConnectionStatus();
            }
            case 12: {
                return labelInfo.getTaskType();
            }
            case 13: {
                return labelInfo.getCurrentPage();
            }
            case 14: {
                return labelInfo.getUpdateInfo().getStatus();
            }
            case 15: {
                return labelInfo.getUpdateInfo().getUpdateError();
            }
            case 16: {
                return labelInfo.getUpdateInfo().getUpdatedAt();
            }
        }
        return null;
    }

    private String createTagsString(Set<String> tags) {
        StringBuilder builder = new StringBuilder();
        for (String tag : tags) {
            builder.append(tag);
            builder.append(", ");
        }
        String tagString = builder.toString();
        return tagString.length() > 2 ? tagString.substring(0, tagString.length() - 2) : tagString;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void refresh(Collection<LabelInfo> labelInfos) {
        this.labelInfos.clear();
        this.labelInfos.addAll(labelInfos);
        this.fireTableDataChanged();
    }

    public LabelInfo getLabelInfo(int rowIndex) {
        return this.labelInfos.get(rowIndex);
    }
}

