/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.template.editor.model.FontPreviewContainer;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class FontPreviewTableModel
extends AbstractTableModel {
    private final FontPreviewContainer container;
    private final List<String> mapping = new ArrayList<String>();

    public FontPreviewTableModel(FontPreviewContainer container) {
        this.container = container;
        for (String fontName : container.getFontPreviews().keySet()) {
            this.mapping.add(fontName);
        }
    }

    @Override
    public int getRowCount() {
        return this.mapping.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Font";
            }
            case 1: {
                return "Preview";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return BufferedImage.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String fontName = this.mapping.get(rowIndex);
        if (columnIndex == 0) {
            return fontName;
        }
        if (columnIndex == 1) {
            return this.container.getFontPreviews().get(fontName);
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public String getFontName(int rowIndex) {
        return this.mapping.get(rowIndex);
    }
}

