/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.tasks.TemplateTask;
import at.mrdevelopment.esl.tasks.TemplateXMLTask;
import at.mrdevelopment.esl.tasks.UpdateImageFactory;
import at.mrdevelopment.esl.template.DOMTemplateSource;
import at.mrdevelopment.esl.template.ESLImage;
import at.mrdevelopment.esl.template.ImageRenderingException;
import at.mrdevelopment.esl.template.TemplateSource;
import at.mrdevelopment.esl.template.editor.model.FontPreviewConfiguration;
import at.mrdevelopment.esl.template.editor.view.FontsView;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;

public class FontPreviewContainer {
    private static final float TEXT_PADDING_FACTOR = 1.2f;
    private static final String DEFAULT_PREVIEW_TEMPLATE = "data/templates/fontpreview.xsl";
    private static final LabelId DEFAULT_LABEL_ID = new LabelId(Address.fromString((String)"B1000000"));
    private Map<String, BufferedImage> fontPreviews;
    private final XMLToolkit xmlToolkit;
    private UpdateImageFactory updateImageFactory;
    private final FontsView fontsView;

    public FontPreviewContainer(FontsView fontsView) throws InitializationException {
        this.fontsView = fontsView;
        this.fontPreviews = new LinkedHashMap<String, BufferedImage>();
        this.xmlToolkit = new XMLToolkit();
        this.updateImageFactory = new UpdateImageFactory();
        this.loadFonts();
    }

    private void loadFonts() {
        this.fontPreviews.clear();
        Object[] availableFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Arrays.sort(availableFonts);
        for (Object fontName : availableFonts) {
            this.fontPreviews.put((String)fontName, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(FontPreviewConfiguration configuration, ExecutionStatus status) throws SerializeException, ImageRenderingException {
        Element rootFromFile;
        File workingDirectory = new File(DEFAULT_PREVIEW_TEMPLATE).getParentFile();
        try {
            rootFromFile = this.xmlToolkit.getDocumentRootFromFile(new File(DEFAULT_PREVIEW_TEMPLATE));
        }
        catch (FileNotFoundException exc) {
            throw new SerializeException(exc);
        }
        HashSet<String> fonts = null;
        Map<String, BufferedImage> map = this.fontPreviews;
        synchronized (map) {
            this.loadFonts();
            fonts = new HashSet<String>(this.fontPreviews.keySet());
        }
        for (String fontName : fonts) {
            try {
                Font font = new Font(fontName, (configuration.isBold() ? 1 : 0) + (configuration.isItalic() ? 2 : 0), configuration.getFontSize());
                Rectangle2D bounds = font.getStringBounds(configuration.getText(), this.fontsView.getFontRenderContext());
                int height = (int)(bounds.getHeight() * (double)1.2f);
                int width = (int)(bounds.getWidth() * (double)configuration.getCondenseFactor() * (double)1.2f);
                TemplateXMLTask templateTask = new TemplateXMLTask(DEFAULT_LABEL_ID, TaskPriority.DEFAULT, 0L, false, (TemplateSource)new DOMTemplateSource(workingDirectory, new DOMSource(rootFromFile.getOwnerDocument())), configuration.toXML(fontName, width, height), Page.DEFAULT, false);
                ESLImage eslImage = this.updateImageFactory.createFromTemplateTask((TemplateTask)templateTask, null, false, false);
                this.fontPreviews.put(fontName, eslImage.getImage());
            }
            catch (Exception exc) {
                status.addElement(new ExceptionElement((Exception)((Object)new ImageRenderingException(String.format("Error rendering font %s", fontName), new Object[]{exc}))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, BufferedImage> getFontPreviews() {
        Map<String, BufferedImage> map = null;
        Map<String, BufferedImage> map2 = this.fontPreviews;
        synchronized (map2) {
            map = Collections.unmodifiableMap(this.fontPreviews);
        }
        return map;
    }
}

