/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FontPreviewConfiguration {
    private final int fontSize;
    private final boolean italic;
    private final boolean bold;
    private final String text;
    private final XMLToolkit xmlToolkit;
    private final float condenseFactor;

    public FontPreviewConfiguration(int fontSize, float condenseFactor, boolean italic, boolean bold, String text) throws InitializationException {
        this.fontSize = fontSize;
        this.condenseFactor = condenseFactor;
        this.italic = italic;
        this.bold = bold;
        this.text = text;
        this.xmlToolkit = new XMLToolkit();
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public String getText() {
        return this.text;
    }

    public float getCondenseFactor() {
        return this.condenseFactor;
    }

    public Document toXML(String fontName, int width, int height) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("FontPreview");
        Element widthElement = document.createElement("Width");
        widthElement.setTextContent(String.valueOf(width));
        root.appendChild(widthElement);
        Element heightElement = document.createElement("Height");
        heightElement.setTextContent(String.valueOf(height));
        root.appendChild(heightElement);
        Element fontSizeElement = document.createElement("FontSize");
        fontSizeElement.setTextContent(String.valueOf(this.fontSize));
        root.appendChild(fontSizeElement);
        Element condenseElement = document.createElement("CondenseFactor");
        condenseElement.setTextContent(String.valueOf(this.condenseFactor));
        root.appendChild(condenseElement);
        Element boldElement = document.createElement("Bold");
        boldElement.setTextContent(this.bold ? "bold" : "normal");
        root.appendChild(boldElement);
        Element italicElement = document.createElement("Italic");
        italicElement.setTextContent(this.italic ? "italic" : "normal");
        root.appendChild(italicElement);
        Element textElement = document.createElement("Text");
        textElement.setTextContent(this.text);
        root.appendChild(textElement);
        Element fontNameElement = document.createElement("FontName");
        fontNameElement.setTextContent(fontName);
        root.appendChild(fontNameElement);
        document.appendChild(root);
        return document;
    }
}

