/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.tasks.EnvironmentSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;

public class EnvironmentEntryTableModel
extends DefaultTableModel {
    private Map<String, String> entries = new HashMap<String, String>();
    private List<String> mapping = new ArrayList<String>();

    public EnvironmentEntryTableModel(EnvironmentSource environmentSource) {
        this.entries.putAll(environmentSource.getEnvironment());
        for (String key : this.entries.keySet()) {
            this.mapping.add(key);
        }
    }

    @Override
    public int getRowCount() {
        return this.entries != null ? this.entries.size() : 0;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Key";
        }
        return "Value";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < this.mapping.size()) {
            String key = this.mapping.get(rowIndex);
            if (columnIndex == 0) {
                return key;
            }
            return this.entries.get(key);
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue != null && !aValue.toString().isEmpty()) {
            if (columnIndex == 0) {
                String oldValue = this.mapping.get(rowIndex);
                this.mapping.set(rowIndex, aValue.toString());
                this.entries.put(aValue.toString(), this.entries.remove(oldValue));
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            } else if (columnIndex == 1) {
                this.entries.put(this.mapping.get(rowIndex), aValue.toString());
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
        }
    }

    public void addEntry(String key, String value) {
        if (this.mapping.contains(key)) {
            this.entries.put(key, value);
            this.fireTableCellUpdated(this.mapping.indexOf(key), 1);
        } else {
            this.mapping.add(key);
            this.entries.put(key, value);
            this.fireTableRowsInserted(this.entries.size() - 1, this.entries.size() - 1);
        }
    }

    public void removeEntry(String key) {
        int index = this.mapping.indexOf(key);
        if (index >= 0) {
            this.mapping.remove(index);
            this.entries.remove(key);
            int firstIndex = index == 0 ? 0 : index - 1;
            int lastIndex = index == this.mapping.size() ? index - 1 : index;
            this.fireTableRowsDeleted(firstIndex, lastIndex);
        }
    }

    public Map<String, String> getEntries() {
        return this.entries;
    }
}

