/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.tasks.TemplateTask;
import at.mrdevelopment.esl.tasks.TemplateXMLTask;
import at.mrdevelopment.esl.template.DOMTemplateSource;
import at.mrdevelopment.esl.template.ESLImage;
import at.mrdevelopment.esl.template.ImageTemplate;
import at.mrdevelopment.esl.template.ImageXMLSerializer;
import at.mrdevelopment.esl.template.TemplateSource;
import at.mrdevelopment.esl.template.editor.common.Change;
import at.mrdevelopment.esl.template.editor.common.Changeset;
import at.mrdevelopment.esl.template.editor.common.FieldType;
import at.mrdevelopment.esl.template.editor.common.TemplateDesignValidator;
import at.mrdevelopment.esl.template.editor.model.AbstractTemplateModel;
import at.mrdevelopment.esl.template.editor.model.TemplateXSLSerializer;
import at.mrdevelopment.esl.template.editor.model.XSLTemplate;
import at.mrdevelopment.esl.template.editor.model.XSLTemplateElement;
import at.mrdevelopment.esl.template.editor.view.SourceEditorView;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StringElement;
import at.mrdevelopment.toolkit.gui.DisplayableOption;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.options.InvalidOptionValueException;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.options.converter.ConversionException;
import at.mrdevelopment.toolkit.options.converter.IntegerStringConverter;
import at.mrdevelopment.toolkit.tree.Path;
import at.mrdevelopment.toolkit.tree.TreeException;
import at.mrdevelopment.toolkit.tree.TreeNode;
import at.mrdevelopment.toolkit.xml.XMLValidationResult;
import at.mrdevelopment.toolkit.xml.XMLValidator;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class DesignTemplateModel
extends AbstractTemplateModel {
    static ESLLogger logger = ESLLogger.getLogger(DesignTemplateModel.class);
    public static final int NO_FIELD_ID = -1;
    private ImageXMLSerializer templateXMLSerializer;
    private TemplateXSLSerializer templateXSLSerializer;
    private IntegerStringConverter stringConverter;
    private XSLTemplate xslTemplate;
    private BufferedImage image;
    private TemplateDesignValidator templateDesignValidator;
    private boolean faultyTemplate = true;
    private XMLValidator designValidator = new XMLValidator("image.xsd");

    public DesignTemplateModel() throws InitializationException {
        this.templateXMLSerializer = new ImageXMLSerializer();
        this.templateXSLSerializer = new TemplateXSLSerializer(this);
        this.templateDesignValidator = new TemplateDesignValidator();
        this.stringConverter = new IntegerStringConverter();
    }

    public boolean hasFieldId(int fieldId) {
        return this.xslTemplate != null && this.xslTemplate.getField(fieldId) != null;
    }

    public TreeNode<DisplayableOption, String> getOption(int fieldId, Path optionPath) {
        try {
            XSLTemplateElement field = this.xslTemplate.getField(fieldId);
            if (field == null) {
                logger.error("Field with id " + fieldId + " is null.");
                return null;
            }
            return field.getOptions().getNodeFromAbsolutePath(optionPath);
        }
        catch (TreeException exc) {
            this.setDefaultDesignImage();
            this.addExecutionStatus(new ExceptionElement(exc));
            return null;
        }
    }

    public boolean isFieldSafeToDelete(int fieldId) {
        XSLTemplateElement field = this.xslTemplate.getField(fieldId);
        return field != null && field.isComprehensible();
    }

    public FieldType getFieldType(int fieldId) {
        if (this.xslTemplate == null) {
            return null;
        }
        XSLTemplateElement field = this.xslTemplate.getField(fieldId);
        if (field == null) {
            logger.error("Field with id " + fieldId + " is null.");
            return null;
        }
        return field.getNestedFieldType();
    }

    public void removeField(int fieldId, Changeset changeset) {
        try {
            this.xslModified = true;
            this.xslTemplate.removeField(fieldId, changeset);
        }
        catch (OptionException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (TreeException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
    }

    public int addField(int fieldId, FieldType fieldType, Changeset changeset, Shape fieldBounds, Element tagElement) {
        switch (fieldType) {
            case BARCODE: {
                return this.addBarcodeField(fieldId, changeset, fieldBounds, tagElement);
            }
            case IMAGE: {
                return this.addImageField(fieldId, changeset, fieldBounds, tagElement);
            }
            case TEXT: {
                return this.addTextField(fieldId, changeset, fieldBounds, tagElement);
            }
            case RECT: {
                return this.addRect(fieldId, changeset, fieldBounds, tagElement);
            }
            case LINE: {
                return this.addLine(fieldId, changeset, fieldBounds, tagElement);
            }
            case ELLIPSE: {
                return this.addEllipse(fieldId, changeset, fieldBounds, tagElement);
            }
            case LIST: {
                return this.addListField(fieldId, changeset, fieldBounds, tagElement);
            }
        }
        return -1;
    }

    public int addBarcodeField(Changeset changeset, Shape fieldBounds) {
        try {
            this.xslModified = true;
            return this.xslTemplate.addBarcodeField(changeset, fieldBounds);
        }
        catch (OptionException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (TreeException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        return -1;
    }

    public int addBarcodeField(int fieldId, Changeset changeset, Shape fieldBounds, Element tagElement) {
        try {
            this.xslModified = true;
            return this.xslTemplate.addBarcodeField(fieldId, changeset, fieldBounds, tagElement);
        }
        catch (OptionException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (TreeException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        return -1;
    }

    public int addTextField(Changeset changeset, Shape fieldBounds) {
        try {
            this.xslModified = true;
            return this.xslTemplate.addTextField(changeset, fieldBounds);
        }
        catch (OptionException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (TreeException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        return -1;
    }

    public int addTextField(int fieldId, Changeset changeset, Shape fieldBounds, Element tagElement) {
        try {
            this.xslModified = true;
            return this.xslTemplate.addTextField(fieldId, changeset, fieldBounds, tagElement);
        }
        catch (OptionException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (TreeException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        return -1;
    }

    public int addListField(Changeset changeset, Shape fieldBounds) {
        try {
            this.xslModified = true;
            return this.xslTemplate.addListField(changeset, fieldBounds);
        }
        catch (OptionException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (TreeException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        return -1;
    }

    public int addListField(int fieldId, Changeset changeset, Shape fieldBounds, Element tagElement) {
        try {
            this.xslModified = true;
            return this.xslTemplate.addListField(fieldId, changeset, fieldBounds, tagElement);
        }
        catch (OptionException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (TreeException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        return -1;
    }

    public int addImageField(Changeset changeset, Shape fieldBounds) {
        try {
            this.xslModified = true;
            return this.xslTemplate.addImageField(changeset, fieldBounds);
        }
        catch (OptionException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (TreeException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        return -1;
    }

    public int addImageField(int fieldId, Changeset changeset, Shape fieldBounds, Element tagElement) {
        try {
            this.xslModified = true;
            return this.xslTemplate.addImageField(fieldId, changeset, fieldBounds, tagElement);
        }
        catch (OptionException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (TreeException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        return -1;
    }

    public int addImageFieldWithData(String base64String, Rectangle fieldBounds) {
        try {
            this.xslModified = true;
            return this.xslTemplate.addImageFieldWithData(base64String, fieldBounds);
        }
        catch (OptionException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (TreeException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        return -1;
    }

    public int addImageFieldWithSrc(String relativePath, Rectangle fieldBounds) {
        try {
            this.xslModified = true;
            return this.xslTemplate.addImageFieldWithSrc(relativePath, fieldBounds);
        }
        catch (OptionException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (TreeException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        return -1;
    }

    public int addRect(Changeset changeset, Shape fieldBounds) {
        try {
            this.xslModified = true;
            return this.xslTemplate.addRectField(changeset, fieldBounds);
        }
        catch (OptionException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (TreeException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        return -1;
    }

    public int addRect(int fieldId, Changeset changeset, Shape fieldBounds, Element tagElement) {
        try {
            this.xslModified = true;
            return this.xslTemplate.addRectField(fieldId, changeset, fieldBounds, tagElement);
        }
        catch (OptionException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (TreeException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        return -1;
    }

    public int addEllipse(int fieldId, Changeset changeset, Shape fieldBounds, Element tagElement) {
        try {
            this.xslModified = true;
            return this.xslTemplate.addEllipseField(fieldId, changeset, fieldBounds, tagElement);
        }
        catch (OptionException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (TreeException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        return -1;
    }

    public int addEllipse(Changeset changeset, Shape fieldBounds) {
        try {
            this.xslModified = true;
            return this.xslTemplate.addEllipseField(changeset, fieldBounds);
        }
        catch (OptionException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (TreeException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        return -1;
    }

    public int addLine(Changeset changeset, Shape fieldBounds) {
        try {
            this.xslModified = true;
            return this.xslTemplate.addLineField(changeset, fieldBounds);
        }
        catch (OptionException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (TreeException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        return -1;
    }

    public int addLine(int fieldId, Changeset changeset, Shape fieldBounds, Element tagElement) {
        try {
            this.xslModified = true;
            return this.xslTemplate.addLineField(fieldId, changeset, fieldBounds, tagElement);
        }
        catch (OptionException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (TreeException exc) {
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        return -1;
    }

    public Changeset setRootImageOption(Path optionPath, String value, boolean quiet, boolean complex) throws InvalidOptionValueException {
        if (this.xslTemplate == null) {
            return new Changeset();
        }
        try {
            Changeset changeset = new Changeset();
            this.xslTemplate.setOption(optionPath, value, changeset, complex);
            File workingDirectory = new File(this.xslFileName).getParentFile();
            DOMSource source = this.getDOMSourceFromString(this.getStringFromDOMSource(this.xslTemplate.getDOMSource()));
            TemplateXMLTask task = new TemplateXMLTask(this.getLabelId(), TaskPriority.DEFAULT, this.getExternalId(), false, (TemplateSource)new DOMTemplateSource(workingDirectory, source), this.getXMLDocument(), this.getPage(), false);
            DOMSource recordSource = this.updateImageFactory.buildRecordSource((TemplateTask)task);
            XMLValidationResult result = this.designValidator.validate(source, recordSource);
            if (result.isErrorOcurred()) {
                for (Change change : changeset.inReverseOrder()) {
                    this.xslTemplate.setOption(change.getPath(), change.getFrom(), new Changeset(), complex);
                }
                throw new InvalidOptionValueException(-1, optionPath, value, result, changeset.inForwardOrder().size() > 0 ? changeset.inForwardOrder().get(0).getPossibleValues() : "-");
            }
            if (!quiet) {
                this.refreshOnDesignAction();
            }
            this.xslModified = true;
            return changeset;
        }
        catch (OptionException exc) {
            if (exc instanceof InvalidOptionValueException) {
                throw (InvalidOptionValueException)exc;
            }
            this.setDefaultDesignImage();
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
            return new Changeset();
        }
        catch (TreeException exc) {
            this.setDefaultDesignImage();
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
            return new Changeset();
        }
        catch (Exception exc) {
            this.setDefaultDesignImage();
            logger.logExceptionIfDebugEnabled(exc);
            return new Changeset();
        }
    }

    public Changeset setFieldOption(int fieldId, Path optionPath, String value, boolean quiet, boolean complex) throws InvalidOptionValueException {
        if (this.xslTemplate == null) {
            return new Changeset();
        }
        try {
            Changeset changeset = new Changeset();
            XSLTemplateElement field = this.xslTemplate.getField(fieldId);
            if (field == null) {
                logger.error("Field with id " + fieldId + " is null. (Setting Canvas options is not yet implemented.)");
                return new Changeset();
            }
            field.setOption(optionPath, value, changeset, complex);
            File workingDirectory = new File(this.xslFileName).getParentFile();
            DOMSource source = this.getDOMSourceFromString(this.getStringFromDOMSource(this.xslTemplate.getDOMSource()));
            TemplateXMLTask task = new TemplateXMLTask(this.getLabelId(), TaskPriority.DEFAULT, this.getExternalId(), false, (TemplateSource)new DOMTemplateSource(workingDirectory, source), this.getXMLDocument(), this.getPage(), false);
            DOMSource recordSource = this.updateImageFactory.buildRecordSource((TemplateTask)task);
            XMLValidationResult result = this.designValidator.validate(source, recordSource);
            if (result.isErrorOcurred()) {
                for (Change change : changeset.inReverseOrder()) {
                    field.setOption(change.getPath(), change.getFrom(), new Changeset(), complex);
                }
                throw new InvalidOptionValueException(fieldId, optionPath, value, result, changeset.inForwardOrder().size() > 0 ? changeset.inForwardOrder().get(0).getPossibleValues() : "-");
            }
            if (!quiet) {
                this.refreshOnDesignAction();
            }
            this.xslModified = true;
            return changeset;
        }
        catch (OptionException exc) {
            if (exc instanceof InvalidOptionValueException) {
                throw (InvalidOptionValueException)exc;
            }
            this.setDefaultDesignImage();
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
            return new Changeset();
        }
        catch (TreeException exc) {
            this.setDefaultDesignImage();
            this.addExecutionStatus(new ExceptionElement(exc));
            logger.logExceptionIfDebugEnabled(exc);
            return new Changeset();
        }
        catch (Exception exc) {
            this.setDefaultDesignImage();
            logger.logExceptionIfDebugEnabled(exc);
            return new Changeset();
        }
    }

    public void setFieldBounds(int fieldId, Shape shape) throws OptionException {
        if (this.xslTemplate != null && this.checkBounds(shape)) {
            try {
                this.xslTemplate.setBounds(fieldId, shape, new Changeset());
                this.xslModified = true;
            }
            catch (OptionException exc) {
                this.addExecutionStatus(new ExceptionElement(exc));
                logger.logExceptionIfDebugEnabled(exc);
            }
            catch (TreeException exc) {
                this.addExecutionStatus(new ExceptionElement(exc));
                logger.logExceptionIfDebugEnabled(exc);
            }
            catch (Exception exc) {
                logger.logExceptionIfDebugEnabled(exc);
            }
            this.refreshOnDesignAction("Refresh Design");
        }
    }

    private boolean checkBounds(Shape shape) throws OptionException {
        return this.xslTemplate.getTemplateBounds().contains(shape.getBounds());
    }

    public XSLTemplate getTemplate() {
        return this.xslTemplate;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    private void setDefaultDesignImage() {
        if (this.xslTemplate == null) {
            this.image = ImageUtils.createImage(264, 176, 12);
        } else {
            int width = 264;
            int height = 176;
            try {
                width = this.stringConverter.reconvert(this.xslTemplate.getTemplateOptions().getNode("width").getNodeElement().getValue());
                height = this.stringConverter.reconvert(this.xslTemplate.getTemplateOptions().getNode("height").getNodeElement().getValue());
            }
            catch (ConversionException exc) {
                logger.logExceptionIfDebugEnabled(exc);
            }
            catch (TreeException exc) {
                logger.logExceptionIfDebugEnabled(exc);
            }
            catch (Exception exc) {
                logger.logExceptionIfDebugEnabled(exc);
            }
            this.image = ImageUtils.createImage(width, height, 12);
        }
    }

    private void recalculateDesignTemplate() {
        if (!this.xslDocumentIsEmpty() && super.isDataValidForPreview()) {
            try {
                this.xslTemplate = this.templateXSLSerializer.parseTemplate(new InputSource(new ByteArrayInputStream(((SourceEditorView)this.sourceCodeMap.get("XSL")).getSourceString().getBytes("UTF-8"))));
                this.faultyTemplate = false;
            }
            catch (Exception exc) {
                this.faultyTemplate = true;
                logger.logExceptionIfDebugEnabled(exc);
                this.addExecutionStatus(new ExceptionElement(exc));
            }
        } else {
            this.xslTemplate = null;
            this.faultyTemplate = true;
        }
    }

    private void recalculateDesignImage() {
        if (super.isDataValidForPreview() && !this.faultyTemplate) {
            try {
                File workingDirectory = new File(this.xslFileName).getParentFile();
                DOMSource imageSource = this.templateXMLSerializer.transformTemplate((Source)this.getDOMSourceFromString(this.getStringFromDOMSource(this.xslTemplate.getDOMSource())), (Source)this.getRecordSource());
                ImageTemplate imageTemplate = this.templateXMLSerializer.parseImage(workingDirectory, imageSource);
                this.xslTemplate.update(imageTemplate.getTemplateTree());
                ESLImage eslImage = new ESLImage(imageTemplate);
                this.xslTemplate.setRelativePostitionsFromTemplate(imageTemplate);
                this.image = eslImage.getImage();
            }
            catch (Exception exc) {
                this.setDefaultDesignImage();
                logger.logExceptionIfDebugEnabled(exc);
                this.addExecutionStatus(new ExceptionElement(exc));
            }
        } else {
            this.setDefaultDesignImage();
        }
    }

    @Override
    public void refresh() {
        if (super.isAutomaticRenderingEnabled()) {
            super.refresh();
            if (this.isDesignViewEnabled()) {
                if (this.templateDesignValidator.validate(new ByteArrayInputStream(((SourceEditorView)this.sourceCodeMap.get("XSL")).getSourceString().getBytes()))) {
                    this.recalculateDesignTemplate();
                    this.recalculateDesignImage();
                    this.setChanged();
                    this.notifyObservers("Refresh Design");
                } else {
                    this.addExecutionStatus(new StringElement("Complex XSL template detected. Deactivating Design View", ExecutionStatusElement.ErrorLevel.WARNING));
                    this.setDefaultDesignImage();
                    this.setChanged();
                    this.notifyObservers("Disable Design");
                    return;
                }
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void refreshOnDesignAction(String command) {
        this.clearExecutionStatus();
        this.refreshSource();
        this.updatePreview();
        this.recalculateDesignImage();
        this.setChanged();
        this.notifyObservers(command);
    }

    public void refreshOnDesignAction() {
        this.refreshOnDesignAction("");
    }

    @Override
    public void refreshToDefault() {
        this.setDefaultDesignImage();
        super.refreshToDefault();
    }

    private void refreshSource() {
        if (this.xslTemplate != null && !this.faultyTemplate) {
            try {
                ((SourceEditorView)this.sourceCodeMap.get("XSL")).updateDocument(this.getStringFromDOMSource(this.xslTemplate.getDOMSource()));
                this.xslModified = true;
            }
            catch (Exception exc) {
                logger.logExceptionIfDebugEnabled(exc);
                this.addExecutionStatus(new ExceptionElement(exc));
            }
        }
    }

    public XSLTemplateElement getField(int fieldId) {
        return this.xslTemplate.getField(fieldId);
    }

    public void updateSourceFromTemplate() {
        this.refreshSource();
    }

    public void importTagElement(Element tagElement, Element parentElement, Node nextTagElement) {
        if (nextTagElement == null) {
            parentElement.appendChild(tagElement);
        } else {
            parentElement.insertBefore(tagElement, nextTagElement);
        }
    }
}

