/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.template.editor.model.XMLRecordInterface;
import at.mrdevelopment.toolkit.http.XMLContentProducerFactory;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public abstract class AbstractXMLRecord
implements XMLRecordInterface {
    private final String id;
    private boolean modified;
    private Element xmlRecordElement;
    private String contentString;
    private boolean entriesUpdated = true;

    public AbstractXMLRecord(String id, Document document, boolean initialModifiedState) throws SerializeException, IOException {
        this.xmlRecordElement = document.getDocumentElement();
        this.contentString = XMLContentProducerFactory.newInstance().toString(document);
        this.modified = initialModifiedState;
        this.id = id;
    }

    public AbstractXMLRecord(Document document, String contentString, boolean initialModifiedState) {
        this.contentString = contentString;
        this.id = UUID.randomUUID().toString();
        this.xmlRecordElement = document.getDocumentElement();
    }

    @Override
    public Document getDocument() {
        if (!this.entriesUpdated) {
            this.updateEntriesFromString();
        }
        return this.xmlRecordElement != null ? (Document)this.xmlRecordElement.getOwnerDocument().cloneNode(true) : null;
    }

    private void updateEntriesFromString() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.xmlRecordElement = builder.parse(new InputSource(new ByteArrayInputStream(this.contentString.getBytes("UTF-8")))).getDocumentElement();
            this.entriesUpdated = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Element getRecordElement() {
        return this.xmlRecordElement;
    }

    @Override
    public String getContentString() {
        return this.contentString;
    }

    @Override
    public void updateContentString(String newContent) {
        if (!this.contentString.equals(newContent)) {
            this.contentString = newContent;
            this.entriesUpdated = false;
            this.modified = true;
        }
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    protected void setModified(boolean modified) {
        this.modified = modified;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return String.format("[XMLRecord]: %s", this.id);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractXMLRecord otherRecord = (AbstractXMLRecord)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)otherRecord.id).append((Object)this.contentString, (Object)otherRecord.getContentString()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 37).append((Object)this.id).toHashCode();
    }

    @Override
    public void saveRecord(String fileName) throws FileNotFoundException, IOException {
        IOUtils.write((String)this.contentString, (OutputStream)new FileOutputStream(new File(fileName)));
        this.modified = false;
    }

    @Override
    public String getDisplayName() {
        String name = this.getId();
        name = name + (this.isModified() ? "*" : "");
        return name;
    }
}

