/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.model;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.LabelTagsLookup;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.tasks.DefaultEnvironmentSource;
import at.mrdevelopment.esl.tasks.DefaultRecordSourceLogger;
import at.mrdevelopment.esl.tasks.EnvironmentSource;
import at.mrdevelopment.esl.tasks.RecordSourceLogger;
import at.mrdevelopment.esl.tasks.TemplateTask;
import at.mrdevelopment.esl.tasks.TemplateXMLTask;
import at.mrdevelopment.esl.tasks.UpdateImageFactory;
import at.mrdevelopment.esl.template.DOMTemplateSource;
import at.mrdevelopment.esl.template.ESLImage;
import at.mrdevelopment.esl.template.ImageRenderingException;
import at.mrdevelopment.esl.template.TemplateSource;
import at.mrdevelopment.esl.template.editor.common.RecordRenderingExceptionElement;
import at.mrdevelopment.esl.template.editor.common.TemplateEditorPreferences;
import at.mrdevelopment.esl.template.editor.model.TemplateEditorLabelTagsLookup;
import at.mrdevelopment.esl.template.editor.model.TemplateEnvironmentSource;
import at.mrdevelopment.esl.template.editor.model.TemplateModel;
import at.mrdevelopment.esl.template.editor.model.XMLFileRecordsContainer;
import at.mrdevelopment.esl.template.editor.model.XMLRecordInterface;
import at.mrdevelopment.esl.template.editor.model.XMLRecordSource;
import at.mrdevelopment.esl.template.editor.model.XMLRecordsContainer;
import at.mrdevelopment.esl.template.editor.model.XMLServerRecordsContainer;
import at.mrdevelopment.esl.template.editor.view.SourceEditorView;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.RenderingExceptionElement;
import at.mrdevelopment.toolkit.StringElement;
import at.mrdevelopment.toolkit.XMLValidationElement;
import at.mrdevelopment.toolkit.gui.IconUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import at.mrdevelopment.toolkit.xml.XMLValidationResult;
import at.mrdevelopment.toolkit.xml.XMLValidator;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public abstract class AbstractTemplateModel
extends Observable
implements TemplateModel {
    static ESLLogger logger = ESLLogger.getLogger(AbstractTemplateModel.class);
    public static final String DOC_TYPE_XSL = "XSL";
    public static final String DOC_TYPE_RECORD_SOURCE = "RECORD";
    public static final String DOC_TYPE_RENDERING_SOURCE = "RENDERING";
    public static final String TYPE_SETTINGS = "SETTINGS";
    private static final long DEFAULT_EXTERNAL_ID = 0L;
    private static final Page DEFAULT_PAGE = Page.PAGE_0;
    private static final LabelId DEFAULT_LABEL_ID = new LabelId(Address.fromString((String)"A1000000"));
    protected Image image;
    protected String xslFileName;
    protected XMLRecordsContainer container;
    protected LabelId labelId = DEFAULT_LABEL_ID;
    protected Page page = DEFAULT_PAGE;
    protected long externalId = 0L;
    private ExecutionStatus executionStatus;
    protected XMLToolkit xmlToolkit;
    protected Map<Object, SourceEditorView> sourceCodeMap = new HashMap<Object, SourceEditorView>();
    protected UpdateImageFactory updateImageFactory;
    private BufferedImage defaultPreviewImage;
    private XMLValidator xmlValidator;
    private boolean debugEnabled = false;
    private TemplateEditorPreferences preferences;
    private boolean renderAllRecords;
    protected boolean xslModified;
    private boolean automaticRendering = true;
    private Boolean renderingSuccessful = null;
    private TemplateEditorLabelTagsLookup labelTagsLookup;
    private XMLRecordSource xmlRecord;
    private TemplateEnvironmentSource environmentSource = new TemplateEnvironmentSource(new DefaultEnvironmentSource().getEnvironment());
    private ServiceAddress serverAddress;

    public AbstractTemplateModel() throws InitializationException {
        ImageIcon icon = IconUtils.loadImageIcon("emptyPreview");
        this.defaultPreviewImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 1);
        Graphics2D graphics = this.defaultPreviewImage.createGraphics();
        icon.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        this.labelTagsLookup = new TemplateEditorLabelTagsLookup();
        this.xmlValidator = new XMLValidator("image.xsd");
        this.updateImageFactory = new UpdateImageFactory((RecordSourceLogger)new DefaultRecordSourceLogger(), (EnvironmentSource)this.environmentSource, (LabelTagsLookup)this.labelTagsLookup);
        this.xmlToolkit = new XMLToolkit();
        this.executionStatus = new ExecutionStatus();
        this.preferences = new TemplateEditorPreferences();
        this.container = new XMLFileRecordsContainer(this, this.preferences);
        try {
            this.labelId = LabelId.fromString((String)"B3000000");
            this.page = Page.PAGE_0;
        }
        catch (SerializeException exc) {
            throw new InitializationException(exc);
        }
    }

    public void init() {
        this.addExecutionStatus(new StringElement("Create a new template (File->New Template) or open an exisiting one (File->Open Template)", ExecutionStatusElement.ErrorLevel.WARNING));
        this.setInputEnabled(false);
    }

    public void setXSLFileName(String xslFileName) {
        this.xslFileName = xslFileName;
        this.sourceCodeMap.get(DOC_TYPE_XSL).setFileName(xslFileName);
    }

    public boolean hasXSLFileName() {
        return this.xslFileName != null;
    }

    public boolean xslDocumentIsEmpty() {
        return this.sourceCodeMap.get(DOC_TYPE_XSL).getDocument().getLength() == 0;
    }

    public boolean xmlDocumentIsEmpty() {
        return this.getRecordsContainer().getCurrentRecord() == null;
    }

    @Override
    public ExecutionStatus getStatus() {
        return this.executionStatus;
    }

    @Override
    public void openXSLFile(String xslFileName) {
        try {
            this.clearExecutionStatus();
            this.sourceCodeMap.get(DOC_TYPE_XSL).updateDocument(this.load(xslFileName));
            this.setInputEnabled(!this.isDesignViewEnabled());
            this.xslFileName = xslFileName;
            this.sourceCodeMap.get(DOC_TYPE_XSL).setFileName(xslFileName);
            try {
                this.preferences.addRecentTemplate(new File(xslFileName));
            }
            catch (BackingStoreException exc) {
                logger.logExceptionIfDebugEnabled(exc);
            }
            this.refresh();
            this.xslModified = false;
        }
        catch (IOException exc) {
            logger.logExceptionIfDebugEnabled(exc);
            this.addExecutionStatus(new ExceptionElement(exc));
            try {
                this.preferences.removeRecentTemplate(new File(xslFileName));
            }
            catch (BackingStoreException exc1) {
                logger.logExceptionIfDebugEnabled(exc1);
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    private String load(String fileName) throws IOException {
        return FileUtils.readFileToString((File)new File(fileName));
    }

    public void clearExecutionStatus() {
        if (this.executionStatus != null) {
            this.executionStatus.clearElements();
        }
    }

    @Override
    public void saveXSLFile() {
        if (this.xslModified) {
            Document xslDocument = this.sourceCodeMap.get(DOC_TYPE_XSL).getDocument();
            this.save(xslDocument, this.xslFileName);
            this.xslModified = false;
            if (!this.preferences.getRecentTemplates().contains(this.xslFileName)) {
                try {
                    this.preferences.addRecentTemplate(new File(this.xslFileName));
                }
                catch (BackingStoreException exc) {
                    logger.logExceptionIfDebugEnabled(exc);
                }
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    private void save(Document document, String fileName) {
        try {
            IOUtils.write((String)document.getText(0, document.getLength()), (OutputStream)new FileOutputStream(new File(fileName)));
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
            this.addExecutionStatus(new ExceptionElement(exc));
        }
    }

    @Override
    public void settingsChanged() {
        this.clearExecutionStatus();
        this.refresh();
    }

    @Override
    public void sourceCodeUpdated(SourceEditorView view, Object identifier) {
        if (this.automaticRendering && this.xslFileName != null) {
            this.clearExecutionStatus();
            if (identifier.equals(DOC_TYPE_XSL)) {
                if (this.sourceCodeMap.get(identifier).getDocument().getLength() > 0) {
                    if (this.validate(view) && this.validateXSLTransformation()) {
                        this.refresh();
                        return;
                    }
                    this.renderingSuccessful = false;
                }
                this.refreshToDefault();
            } else if (identifier instanceof XMLRecordInterface) {
                XMLRecordInterface record = (XMLRecordInterface)identifier;
                record.updateContentString(view.getSourceString());
                if (this.validate(view) && this.validateXSLTransformation()) {
                    this.refresh();
                    return;
                }
                this.renderingSuccessful = false;
                this.refreshToDefault();
            }
        }
    }

    public void setXSLModified() {
        this.xslModified = true;
    }

    @Override
    public void refreshToDefault() {
        try {
            this.clearRenderingSource();
            this.clearRecordSource();
        }
        catch (BadLocationException exc) {
            logger.logExceptionIfDebugEnabled(exc);
            this.addExecutionStatus(new ExceptionElement(exc));
        }
        this.setChanged();
        this.notifyObservers(this.getDefaultImage());
    }

    private boolean validate(SourceEditorView view) {
        try {
            XMLValidationResult result = this.xmlValidator.validateXML(view.getDocument().getText(0, view.getDocument().getLength()));
            if (result.isErrorOcurred()) {
                this.addExecutionStatus(new XMLValidationElement(view, result));
                return false;
            }
            return true;
        }
        catch (BadLocationException exc) {
            logger.logExceptionIfDebugEnabled(exc);
            this.addExecutionStatus(new ExceptionElement(exc));
            return false;
        }
    }

    private boolean validate(XMLRecordInterface record) {
        XMLValidationResult result = this.xmlValidator.validateXML(record.getContentString());
        if (result.isErrorOcurred()) {
            this.addExecutionStatus(new XMLValidationElement(record.getId(), result));
            return false;
        }
        return true;
    }

    @Override
    public void updatePreview() {
        if (this.sourceCodeMap.get(DOC_TYPE_XSL).getDocument().getLength() == 0) {
            this.executionStatus.addElement(new StringElement("Template is empty", ExecutionStatusElement.ErrorLevel.ERROR));
            try {
                this.clearRecordSource();
                this.clearRenderingSource();
            }
            catch (BadLocationException exc) {
                this.renderingSuccessful = false;
                logger.logExceptionIfDebugEnabled(exc);
                this.addExecutionStatus(new ExceptionElement(exc));
            }
        } else {
            try {
                this.updateRecordSource();
                this.updateRenderingSource();
                ESLImage eslImage = this.getRenderedESLImage(this.isDebugEnabled());
                if (eslImage != null) {
                    this.renderingSuccessful = eslImage.isSuccessful();
                    this.image = eslImage.getImage();
                } else {
                    this.renderingSuccessful = false;
                    this.image = this.getDefaultImage();
                }
            }
            catch (BadLocationException exc) {
                this.renderingSuccessful = false;
                logger.logExceptionIfDebugEnabled(exc);
                this.addExecutionStatus(new ExceptionElement(exc));
            }
        }
    }

    private void clearRecordSource() throws BadLocationException {
        this.sourceCodeMap.get(DOC_TYPE_RECORD_SOURCE).updateDocument("");
    }

    private void clearRenderingSource() throws BadLocationException {
        this.sourceCodeMap.get(DOC_TYPE_RENDERING_SOURCE).updateDocument("");
    }

    public Image getDefaultImage() {
        return this.defaultPreviewImage;
    }

    public DOMSource getDOMSourceFromString(String sourceString) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return new DOMSource(builder.parse(new InputSource(new ByteArrayInputStream(sourceString.getBytes("UTF-8")))));
        }
        catch (Exception exc) {
            this.executionStatus.addElement(new ExceptionElement(exc));
            return new DOMSource();
        }
    }

    private void updateRecordSource() throws BadLocationException {
        DOMSource recordSource = this.getRecordSource();
        if (recordSource != null) {
            this.sourceCodeMap.get(DOC_TYPE_RECORD_SOURCE).updateDocument(this.getStringFromDOMSource(recordSource));
        } else {
            this.sourceCodeMap.get(DOC_TYPE_RECORD_SOURCE).updateDocument("");
        }
    }

    private void updateRenderingSource() throws BadLocationException {
        DOMSource imageSource = this.getImageSource();
        if (imageSource != null) {
            this.sourceCodeMap.get(DOC_TYPE_RENDERING_SOURCE).updateDocument(this.getStringFromDOMSource(imageSource));
        } else {
            this.sourceCodeMap.get(DOC_TYPE_RENDERING_SOURCE).updateDocument("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStringFromDOMSource(DOMSource source) {
        StringWriter writer = null;
        String returnString = null;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("encoding", "UTF-8");
            writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            returnString = writer.toString();
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
            this.addExecutionStatus(new ExceptionElement(exc));
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException exc) {
                    logger.logExceptionIfDebugEnabled(exc);
                    this.addExecutionStatus(new ExceptionElement(exc));
                }
            }
        }
        return returnString;
    }

    @Override
    public EnvironmentSource getEnvironmentSource() {
        return this.environmentSource;
    }

    @Override
    public void setEnvironmentSource(Map<String, String> environment) {
        this.environmentSource.updateEnvironment(environment);
    }

    @Override
    public LabelId getLabelId() {
        return this.labelId;
    }

    @Override
    public void setLabelId(LabelId labelId) {
        this.labelId = labelId;
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    @Override
    public void setPage(Page page) {
        this.page = page;
    }

    @Override
    public long getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(long externalId) {
        this.externalId = externalId;
    }

    @Override
    public void setLabelTags(Set<String> labelTagSet) {
        this.labelTagsLookup.setTagsForLabel(labelTagSet);
    }

    @Override
    public Set<String> getLabelTags() {
        return this.labelTagsLookup.getTagsForLabel(this.getLabelId());
    }

    @Override
    public org.w3c.dom.Document getXMLDocument() {
        if (this.container.getCurrentRecord() != null) {
            org.w3c.dom.Document document = this.container.getCurrentRecord().getDocument();
            return document != null ? document : this.getEmptyDocument();
        }
        return this.getEmptyDocument();
    }

    private org.w3c.dom.Document getEmptyDocument() {
        org.w3c.dom.Document newDocument = this.xmlToolkit.newDocument();
        Element valuesElement = newDocument.createElement("Values");
        newDocument.appendChild(valuesElement);
        return newDocument;
    }

    @Override
    public void setSourceCode(SourceEditorView sourceEdit, Object identifier) {
        this.sourceCodeMap.put(identifier, sourceEdit);
    }

    @Override
    public String getSourceString(Object identifier) {
        try {
            if (identifier instanceof String && identifier.equals(DOC_TYPE_XSL) && this.xslFileName != null) {
                return this.sourceCodeMap.get(identifier).getSourceString();
            }
            if (identifier instanceof XMLRecordInterface) {
                return ((XMLRecordInterface)identifier).getContentString();
            }
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
            this.addExecutionStatus(new ExceptionElement(exc));
        }
        return null;
    }

    @Override
    public void refresh() {
        if (this.automaticRendering) {
            if (this.isRenderAllRecordsEnabled()) {
                this.createPreviewForAllRecords(true);
            }
            this.updatePreview();
        }
    }

    @Override
    public void addExecutionStatus(ExecutionStatusElement<?> element) {
        this.executionStatus.addElement(element);
    }

    @Override
    public void addExecutionStatus(ExecutionStatusElement<?> element, boolean refresh) {
        this.addExecutionStatus(element);
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public String getXSLFileName() {
        return this.xslFileName;
    }

    @Override
    public DOMSource getRecordSource() {
        try {
            if (this.isDataValidForPreview()) {
                return this.updateImageFactory.buildRecordSource((TemplateTask)this.createTemplateTask());
            }
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
            this.addExecutionStatus(new ExceptionElement(exc));
        }
        return null;
    }

    private boolean validateXSLTransformation() {
        try {
            XMLValidationResult result = this.xmlValidator.validate(new StreamSource(new StringReader(this.getSourceString(DOC_TYPE_XSL))), this.updateImageFactory.buildRecordSource((TemplateTask)this.createTemplateTask()));
            if (result.isErrorOcurred()) {
                this.addExecutionStatus(new XMLValidationElement(result.getErrorHandler().isSaxError() ? this.sourceCodeMap.get(DOC_TYPE_RENDERING_SOURCE) : this.sourceCodeMap.get(DOC_TYPE_XSL), result));
                return false;
            }
            return true;
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
            this.addExecutionStatus(new ExceptionElement(exc));
            return false;
        }
    }

    public DOMSource getImageSource() {
        try {
            if (this.isDataValidForPreview() && this.validateXSLTransformation()) {
                return this.updateImageFactory.buildImageRenderingSource((TemplateTask)this.createTemplateTask());
            }
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
            this.addExecutionStatus(new ExceptionElement(exc));
        }
        return null;
    }

    private ESLImage getRenderedESLImage(boolean debugEnabled) {
        try {
            if (this.isDataValidForPreview()) {
                TemplateXMLTask templateTask = this.createTemplateTask();
                ESLImage eslImage = this.updateImageFactory.createFromTemplateTask((TemplateTask)templateTask, this.executionStatus, debugEnabled, true);
                for (ExecutionStatusElement<?> element : eslImage.getStatus().getElements()) {
                    this.addExecutionStatus(element);
                }
                return eslImage;
            }
        }
        catch (ImageRenderingException exc) {
            if (exc.getCause() != null) {
                OptionException optionException;
                int fieldId = -1;
                if (exc.getCause() instanceof OptionException && (optionException = (OptionException)exc.getCause()).isFieldIdSet()) {
                    fieldId = optionException.getFieldId();
                }
                this.addExecutionStatus(new RenderingExceptionElement((Exception)((Object)exc), fieldId));
            }
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
            this.addExecutionStatus(new ExceptionElement(exc));
        }
        return null;
    }

    @Override
    public Image getRenderedImage() {
        return this.image != null ? this.image : this.getDefaultImage();
    }

    protected TemplateXMLTask createTemplateTask() {
        File workingDirectory = new File(this.xslFileName).getParentFile();
        return new TemplateXMLTask(this.getLabelId(), TaskPriority.DEFAULT, this.getExternalId(), false, (TemplateSource)new DOMTemplateSource(workingDirectory, this.getDOMSourceFromString(this.getSourceString(DOC_TYPE_XSL))), this.getXMLDocument(), this.getPage(), false);
    }

    public boolean isDataValidForPreview() {
        return true;
    }

    @Override
    public void newXSLFile(String xslFileName, String content) {
        this.sourceCodeMap.get(DOC_TYPE_XSL).updateDocument(content);
        this.sourceCodeMap.get(DOC_TYPE_XSL).setFileName(xslFileName);
        this.xslModified = true;
        this.xslFileName = xslFileName;
        try {
            new File(xslFileName).createNewFile();
            this.preferences.addRecentTemplate(new File(xslFileName));
        }
        catch (IOException exc) {
            logger.logExceptionIfDebugEnabled(exc);
            this.addExecutionStatus(new ExceptionElement(exc));
        }
        catch (BackingStoreException exc) {
            logger.logExceptionIfDebugEnabled(exc);
            this.addExecutionStatus(new ExceptionElement(exc));
        }
        this.setInputEnabled(!this.isDesignViewEnabled());
        this.clearExecutionStatus();
        this.refresh();
    }

    public void setInputEnabled(boolean enabled) {
        this.sourceCodeMap.get(DOC_TYPE_XSL).setEditable(enabled);
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(boolean enabled) {
        this.debugEnabled = enabled;
        this.clearExecutionStatus();
        this.setChanged();
        this.notifyObservers();
        this.refresh();
    }

    public boolean isRenderAllRecordsEnabled() {
        return this.renderAllRecords;
    }

    public void setRenderAllRecordsEnabled(boolean enabled) {
        this.renderAllRecords = enabled;
        this.clearExecutionStatus();
        if (enabled) {
            this.createPreviewForAllRecords(true);
        } else if (!enabled && this.getRecordsContainer().getCurrentRecord() != null) {
            this.validate(this.sourceCodeMap.get(this.getRecordsContainer().getCurrentRecord()));
        }
        this.refresh();
    }

    @Override
    public Map<XMLRecordInterface, BufferedImage> createPreviewForAllRecords(boolean includeSelectedRecord) {
        ArrayList elements = new ArrayList();
        this.renderingSuccessful = true;
        HashMap<XMLRecordInterface, BufferedImage> images = new HashMap<XMLRecordInterface, BufferedImage>();
        XMLRecordInterface oldRecord = this.container.getCurrentRecord();
        for (XMLRecordInterface xMLRecordInterface : this.container.getAllRecords()) {
            if (!this.validate(xMLRecordInterface)) {
                for (ExecutionStatusElement<?> element : this.getStatus().getElements()) {
                    if (element instanceof RenderingExceptionElement) {
                        elements.add(new RecordRenderingExceptionElement((RenderingExceptionElement)element, xMLRecordInterface));
                        continue;
                    }
                    elements.add(element);
                }
                this.renderingSuccessful = false;
            }
            this.container.setRecordSelected(xMLRecordInterface.getId());
            ESLImage eslImage = this.getRenderedESLImage(false);
            if (eslImage != null) {
                this.renderingSuccessful = !eslImage.isSuccessful() ? false : this.renderingSuccessful;
                images.put(xMLRecordInterface, eslImage.getImage());
                for (ExecutionStatusElement<?> element : eslImage.getStatus().getElements()) {
                    if (element instanceof RenderingExceptionElement) {
                        elements.add(new RecordRenderingExceptionElement((RenderingExceptionElement)element, xMLRecordInterface));
                        continue;
                    }
                    elements.add(element);
                }
                continue;
            }
            this.renderingSuccessful = false;
        }
        this.clearExecutionStatus();
        for (ExecutionStatusElement executionStatusElement : elements) {
            this.addExecutionStatus(executionStatusElement);
        }
        this.container.setRecordSelected(oldRecord.getId());
        return images;
    }

    public XMLRecordInterface getRecord(Object identifier) {
        return (XMLRecordInterface)identifier;
    }

    public void closeCurrentRecord(Object identifier) {
        this.container.closeCurrentRecord();
    }

    public boolean isDesignViewEnabled() {
        return this.preferences.isDesignModeEnabled();
    }

    public void setDesignViewEnabled(boolean enabled) {
        try {
            this.preferences.storeDesignModeEnabled(enabled);
        }
        catch (BackingStoreException exc) {
            logger.error("Could not store design mode preference value");
            logger.logExceptionIfDebugEnabled(exc);
        }
    }

    public boolean isXSLModified() {
        return this.xslModified;
    }

    public DOMSource getXSLDOMSource() {
        return this.getDOMSourceFromString(this.getSourceString(DOC_TYPE_XSL));
    }

    public List<String> getRecentTemplates() {
        return this.preferences.getRecentTemplates();
    }

    public List<String> getRecentRecords() {
        return this.preferences.getRecentRecords();
    }

    public void setAutomaticRenderingEnabled(boolean enabled) {
        this.automaticRendering = enabled;
    }

    public boolean isAutomaticRenderingEnabled() {
        return this.automaticRendering;
    }

    public void triggerTemplateRendering() {
        this.clearExecutionStatus();
        this.updatePreview();
        this.setChanged();
        this.notifyObservers(this.getRenderedImage());
    }

    @Override
    public Boolean wasRenderingSuccessful() {
        return this.renderingSuccessful;
    }

    public XMLRecordSource getXMLRecord() {
        try {
            this.xmlRecord = new XMLRecordSource(((org.w3c.dom.Document)this.updateImageFactory.buildRecordSource((TemplateTask)this.createTemplateTask()).getNode()).getDocumentElement(), this);
        }
        catch (ImageRenderingException exc) {
            logger.logExceptionIfDebugEnabled(exc);
            this.addExecutionStatus(new ExceptionElement((Exception)((Object)exc)));
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        return this.xmlRecord;
    }

    @Override
    public XMLRecordsContainer getRecordsContainer() {
        return this.container;
    }

    @Override
    public TemplateEditorPreferences getPreferences() {
        return this.preferences;
    }

    @Override
    public void triggerUpdate() {
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void updateContainer(XMLRecordsContainer container) {
        this.container = container;
    }

    public boolean canSendImageToLabels() {
        return this.renderingSuccessful != null && this.renderingSuccessful != false && this.container != null && this.container instanceof XMLServerRecordsContainer;
    }

    @Override
    public ServiceAddress getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public void setServerAddress(ServiceAddress serverAddress) {
        this.serverAddress = serverAddress;
    }

    protected XMLValidator getValidator() {
        return this.xmlValidator;
    }

    public File getWorkingDirectory() {
        return new File(this.xslFileName).getParentFile();
    }
}

