/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.controller.undoredo;

import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.options.OptionException;
import java.awt.Shape;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ResizeElementUndoable
extends AbstractUndoableEdit {
    static ESLLogger logger = ESLLogger.getLogger(ResizeElementUndoable.class);
    private static final long serialVersionUID = 4566717205591070311L;
    private DesignTemplateModel templateModel;
    private int fieldId;
    private Shape shape;
    private Shape oldShape;

    public ResizeElementUndoable(DesignTemplateModel templateModel, int fieldId, Shape oldShape, Shape newShape) {
        this.fieldId = fieldId;
        this.templateModel = templateModel;
        this.setNewShape(newShape);
        this.oldShape = oldShape;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        try {
            this.templateModel.setFieldBounds(this.fieldId, this.oldShape);
        }
        catch (OptionException exc) {
            logger.warn(exc.getMessage());
            logger.logExceptionIfDebugEnabled(exc);
            throw new CannotUndoException();
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        try {
            this.perform();
        }
        catch (OptionException exc) {
            logger.warn(exc.getMessage());
            logger.logExceptionIfDebugEnabled(exc);
            throw new CannotRedoException();
        }
    }

    public void perform() throws OptionException {
        this.templateModel.setFieldBounds(this.fieldId, this.shape);
    }

    public void setNewShape(Shape shape) {
        this.shape = shape;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResizeElementUndoable: Field ID: [");
        builder.append(this.fieldId);
        builder.append("]\n");
        builder.append("New: ");
        builder.append(this.shape.toString());
        builder.append("\n");
        builder.append("Old: ");
        builder.append(this.oldShape.toString());
        return builder.toString();
    }

    @Override
    public String getPresentationName() {
        return "Resize Element";
    }
}

