/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.controller.undoredo;

import at.mrdevelopment.esl.template.editor.common.Changeset;
import at.mrdevelopment.esl.template.editor.common.FieldType;
import at.mrdevelopment.esl.template.editor.controller.undoredo.AbstractDesignUndoable;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import java.awt.Rectangle;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class RemoveFieldUndoable
extends AbstractDesignUndoable {
    private DesignTemplateModel templateModel;
    private FieldType fieldType;
    private Changeset changeset;

    public RemoveFieldUndoable(DesignTemplateModel templateModel, int fieldId) {
        this.templateModel = templateModel;
        this.setFieldId(fieldId);
        this.changeset = new Changeset();
        super.setFieldBounds(templateModel.getField(fieldId).getBounds());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.templateModel.importTagElement(this.getTagElement(), this.getParentElement(), this.getNextTagElement());
        this.performAddOperation(this.getFieldId(), new Changeset());
        this.templateModel.refreshOnDesignAction();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.setTagElement(this.templateModel.getField(this.getFieldId()).getTagElement());
        this.templateModel.removeField(this.getFieldId(), new Changeset());
        this.templateModel.refreshOnDesignAction();
    }

    @Override
    public void perform() {
        this.fieldType = this.templateModel.getFieldType(this.getFieldId());
        this.setTagElement(this.templateModel.getField(this.getFieldId()).getTagElement());
        this.templateModel.removeField(this.getFieldId(), this.changeset);
        this.templateModel.refreshOnDesignAction();
    }

    private void performAddOperation(int fieldId, Changeset changeset) {
        this.templateModel.addField(fieldId, this.fieldType, changeset, this.getFieldBounds(), this.getTagElement());
    }

    @Override
    public String toString() {
        return "RemoveFieldUndoable [templateModel=" + this.templateModel + ", fieldId=" + this.getFieldId() + ", changeset=" + this.changeset + "]";
    }

    @Override
    public String getPresentationName() {
        return "Remove Field " + this.getFieldId();
    }

    @Override
    public Rectangle getDefaultBounds() {
        return new Rectangle(10, 10, 30, 30);
    }
}

