/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.controller.undoredo;

import at.mrdevelopment.esl.template.editor.common.Change;
import at.mrdevelopment.esl.template.editor.controller.DesignTemplateController;
import at.mrdevelopment.esl.template.editor.controller.undoredo.ChangeOptionUndoable;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.toolkit.options.InvalidOptionValueException;
import at.mrdevelopment.toolkit.tree.Path;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ChangeRootImageOptionUndoable
extends ChangeOptionUndoable {
    public ChangeRootImageOptionUndoable(DesignTemplateController templateController, DesignTemplateModel templateModel, Path optionPath, String newValue) {
        super(templateController, templateModel, -1, optionPath, newValue);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        for (int i = this.changeset.inForwardOrder().size() - 1; i >= 0; --i) {
            Change change = this.changeset.inForwardOrder().get(i);
            if (change.getFrom() == null) continue;
            try {
                this.templateModel.setRootImageOption(change.getPath(), change.getFrom(), true, false);
                continue;
            }
            catch (InvalidOptionValueException exc) {
                this.handleInvalidOptionException(exc);
            }
        }
        this.templateModel.refreshOnDesignAction();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        for (Change change : this.changeset.inForwardOrder()) {
            if (change.getTo() == null) continue;
            try {
                this.templateModel.setRootImageOption(change.getPath(), change.getTo(), true, false);
            }
            catch (InvalidOptionValueException exc) {
                this.handleInvalidOptionException(exc);
            }
        }
        this.templateModel.refreshOnDesignAction();
    }

    @Override
    public void perform() {
        try {
            this.changeset = this.templateModel.setRootImageOption(this.optionPath, this.newValue, true, true);
            this.templateModel.refreshOnDesignAction();
        }
        catch (InvalidOptionValueException exc) {
            this.handleInvalidOptionException(exc);
        }
    }

    @Override
    public String toString() {
        return "ChangeRootImageOptionUndoable [templateModel=" + this.templateModel + ", optionPath=" + this.optionPath + ", newValue=" + this.newValue + ", changeset=" + this.changeset + "]";
    }
}

