/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.controller.undoredo;

import at.mrdevelopment.esl.template.editor.common.Change;
import at.mrdevelopment.esl.template.editor.common.Changeset;
import at.mrdevelopment.esl.template.editor.controller.DesignTemplateController;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.toolkit.options.InvalidOptionValueException;
import at.mrdevelopment.toolkit.tree.Path;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ChangeOptionUndoable
extends AbstractUndoableEdit {
    protected DesignTemplateModel templateModel;
    protected int fieldId;
    protected Path optionPath;
    protected String newValue;
    protected Changeset changeset;
    protected DesignTemplateController templateController;

    public ChangeOptionUndoable(DesignTemplateController designTemplateController, DesignTemplateModel templateModel, int fieldId, Path optionPath, String newValue) {
        this.templateController = designTemplateController;
        this.fieldId = fieldId;
        this.templateModel = templateModel;
        this.optionPath = optionPath;
        this.newValue = newValue;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        for (int i = this.changeset.inForwardOrder().size() - 1; i >= 0; --i) {
            Change change = this.changeset.inForwardOrder().get(i);
            if (change.getFrom() == null) continue;
            try {
                this.templateModel.setFieldOption(this.fieldId, change.getPath(), change.getFrom(), true, false);
                continue;
            }
            catch (InvalidOptionValueException exc) {
                this.handleInvalidOptionException(exc);
            }
        }
        this.templateModel.refreshOnDesignAction();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        for (Change change : this.changeset.inForwardOrder()) {
            if (change.getTo() == null) continue;
            try {
                this.templateModel.setFieldOption(this.fieldId, change.getPath(), change.getTo(), true, false);
            }
            catch (InvalidOptionValueException exc) {
                this.handleInvalidOptionException(exc);
            }
        }
        this.templateModel.refreshOnDesignAction();
    }

    public void perform() {
        try {
            this.changeset = this.templateModel.setFieldOption(this.fieldId, this.optionPath, this.newValue, true, true);
            this.templateModel.refreshOnDesignAction();
        }
        catch (InvalidOptionValueException exc) {
            this.handleInvalidOptionException(exc);
        }
    }

    protected void handleInvalidOptionException(InvalidOptionValueException exc) {
        this.templateController.handleInvalidOption(this, exc);
    }

    @Override
    public String toString() {
        return "ChangeOptionUndoable [templateModel=" + this.templateModel + ", fieldId=" + this.fieldId + ", optionPath=" + this.optionPath + ", newValue=" + this.newValue + ", changeset=" + this.changeset + "]";
    }

    @Override
    public String getPresentationName() {
        return "Change option " + this.optionPath;
    }
}

