/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.controller.undoredo;

import at.mrdevelopment.esl.template.editor.common.Changeset;
import at.mrdevelopment.esl.template.editor.controller.undoredo.AbstractDesignUndoable;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import java.awt.Rectangle;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class AddDragAndDropImageUndoable
extends AbstractDesignUndoable {
    private final DesignTemplateModel templateModel;
    private String image;
    private boolean useData;
    private Rectangle bounds;
    private Changeset changeset;

    public AddDragAndDropImageUndoable(DesignTemplateModel templateModel, String image, boolean useData, Rectangle bounds) {
        this.templateModel = templateModel;
        this.image = image;
        this.useData = useData;
        this.bounds = bounds;
        this.changeset = new Changeset();
    }

    @Override
    public void perform() {
        if (this.useData) {
            this.setFieldId(this.templateModel.addImageFieldWithData(this.image, this.bounds));
        } else {
            this.setFieldId(this.templateModel.addImageFieldWithSrc(this.image, this.bounds));
        }
        this.setTagElement(this.templateModel.getField(this.getFieldId()).getTagElement());
        this.templateModel.refreshOnDesignAction();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.setTagElement(this.templateModel.getField(this.getFieldId()).getTagElement());
        this.templateModel.removeField(this.getFieldId(), new Changeset());
        this.templateModel.refreshOnDesignAction();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.templateModel.importTagElement(this.getTagElement(), this.getParentElement(), this.getNextTagElement());
        this.templateModel.addImageField(this.getFieldId(), new Changeset(), this.getFieldBounds(), this.getTagElement());
        this.templateModel.refreshOnDesignAction();
    }

    @Override
    public String toString() {
        return "AddDragAndDropImageUndoable [templateModel=" + this.templateModel + ", fieldId=" + this.getFieldId() + ", changeset=" + this.changeset + "]";
    }

    @Override
    public String getPresentationName() {
        return "Add Image Field";
    }
}

