/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.controller.undoredo;

import at.mrdevelopment.esl.template.editor.common.Changeset;
import at.mrdevelopment.esl.template.editor.controller.undoredo.AbstractDesignUndoable;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class AddBarcodeFieldUndoable
extends AbstractDesignUndoable {
    private DesignTemplateModel templateModel;
    private Changeset changeset;

    public AddBarcodeFieldUndoable(DesignTemplateModel templateModel) {
        this.templateModel = templateModel;
        this.changeset = new Changeset();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.setTagElement(this.templateModel.getField(this.getFieldId()).getTagElement());
        this.templateModel.removeField(this.getFieldId(), new Changeset());
        this.templateModel.refreshOnDesignAction();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.templateModel.importTagElement(this.getTagElement(), this.getParentElement(), this.getNextTagElement());
        this.templateModel.addBarcodeField(this.getFieldId(), new Changeset(), this.getFieldBounds(), this.getTagElement());
        this.templateModel.refreshOnDesignAction();
    }

    @Override
    public void perform() {
        this.setFieldId(this.templateModel.addBarcodeField(this.changeset, this.getFieldBounds()));
        this.setTagElement(this.templateModel.getField(this.getFieldId()).getTagElement());
        this.templateModel.refreshOnDesignAction();
    }

    @Override
    public String toString() {
        return "AddFieldUndoable [templateModel=" + this.templateModel + ", fieldId=" + this.getFieldId() + ", changeset=" + this.changeset + "]";
    }

    @Override
    public String getPresentationName() {
        return "Add Barcode Field";
    }
}

