/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.controller;

import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.template.editor.controller.TemplateController;
import at.mrdevelopment.esl.template.editor.model.TemplateModel;
import at.mrdevelopment.esl.template.editor.model.XMLFileRecord;
import at.mrdevelopment.esl.template.editor.model.XMLFileRecordsContainer;
import at.mrdevelopment.esl.template.editor.model.XMLRecordContainerListener;
import at.mrdevelopment.esl.template.editor.model.XMLRecordInterface;
import at.mrdevelopment.esl.template.editor.model.XMLRecordsContainer;
import at.mrdevelopment.esl.template.editor.model.XMLServerRecordsContainer;
import at.mrdevelopment.esl.template.editor.view.TemplateView;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import javax.imageio.ImageIO;
import javax.swing.undo.UndoManager;
import org.apache.commons.io.FilenameUtils;

public class SimpleTemplateController
implements TemplateController {
    static ESLLogger logger = ESLLogger.getLogger(SimpleTemplateController.class);
    protected TemplateModel templateModel;
    protected UndoManager undoManager = new UndoManager();
    private TemplateView templateView;

    public SimpleTemplateController() throws InitializationException {
        this.undoManager.setLimit(-1);
    }

    @Override
    public TemplateModel getTemplateModel() {
        return this.templateModel;
    }

    @Override
    public void setTemplateModel(TemplateModel templateModel) {
        this.templateModel = templateModel;
    }

    @Override
    public void setTemplateView(TemplateView templateView) {
        this.templateView = templateView;
    }

    @Override
    public TemplateView getTemplateView() {
        return this.templateView;
    }

    @Override
    public void saveXSLFile() {
        this.templateModel.saveXSLFile();
    }

    @Override
    public void loadXSLFile(String xslFileName) {
        this.templateModel.openXSLFile(xslFileName);
        this.undoManager.discardAllEdits();
    }

    @Override
    public UndoManager getUndoManager() {
        if (this.templateView == null) {
            return null;
        }
        UndoManager currentUndoManager = this.templateView.getCurrentlyActiveUndoManager();
        return currentUndoManager != null ? currentUndoManager : this.undoManager;
    }

    @Override
    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    @Override
    public void newXSLFile(String xslFileName, String content) {
        this.templateModel.newXSLFile(xslFileName, content);
    }

    @Override
    public void newXMLRecord() {
        if (!(this.getTemplateModel().getRecordsContainer() instanceof XMLFileRecordsContainer)) {
            try {
                XMLFileRecordsContainer container = new XMLFileRecordsContainer(this.getTemplateModel(), this.getTemplateModel().getPreferences());
                XMLRecordsContainer oldContaienr = this.getTemplateModel().getRecordsContainer();
                this.getTemplateModel().updateContainer(container);
                for (XMLRecordContainerListener listener : oldContaienr.getListeners()) {
                    container.addRecordListener(listener);
                }
            }
            catch (InitializationException exc) {
                logger.warn(exc.getMessage());
                logger.logExceptionIfDebugEnabled(exc);
            }
        }
        ((XMLFileRecordsContainer)this.getTemplateModel().getRecordsContainer()).addNewRecord();
        this.getTemplateModel().triggerUpdate();
        this.getTemplateModel().refresh();
    }

    @Override
    public void exportRecordsAsImage(File outputDirectory) {
        Map<XMLRecordInterface, BufferedImage> images = this.templateModel.createPreviewForAllRecords(true);
        for (XMLRecordInterface record : images.keySet()) {
            try {
                String fileName = new File(record.getDisplayName().replace(FilenameUtils.getExtension((String)record.getDisplayName()), "png")).getName();
                ImageIO.write((RenderedImage)images.get(record), "png", new File(outputDirectory, fileName));
            }
            catch (IOException exc) {
                logger.warn("Could not save image from record %s", record.getDisplayName());
                logger.logExceptionIfDebugEnabled(exc);
                this.templateModel.addExecutionStatus(new ExceptionElement(exc));
            }
        }
    }

    @Override
    public void saveCurrentRecord() {
        if (this.getTemplateModel().getRecordsContainer() instanceof XMLFileRecordsContainer) {
            XMLFileRecordsContainer container = (XMLFileRecordsContainer)this.getTemplateModel().getRecordsContainer();
            if (container.isShowSaveAsCurrentRecord() || !container.canSaveCurrentRecord() && this.getTemplateModel().getRecordsContainer().getCurrentRecord() != null) {
                String fileName = this.getTemplateView().showSaveAsDialog();
                if (fileName != null) {
                    try {
                        this.getTemplateModel().getRecordsContainer().getCurrentRecord().saveRecord(fileName);
                        this.getTemplateModel().getPreferences().addRecentRecord(new File(fileName));
                    }
                    catch (Exception exc) {
                        logger.warn("Could not save current record. %s", exc.getMessage());
                        logger.logExceptionIfDebugEnabled(exc);
                        this.getTemplateModel().addExecutionStatus(new ExceptionElement(exc));
                    }
                }
            } else {
                this.getTemplateModel().getRecordsContainer().saveCurrentRecord();
            }
            this.getTemplateModel().triggerUpdate();
        }
    }

    @Override
    public void loadRecords(List<File> fileList) {
        if (this.getTemplateModel().getRecordsContainer() instanceof XMLServerRecordsContainer) {
            try {
                XMLFileRecordsContainer container = new XMLFileRecordsContainer(this.getTemplateModel(), this.getTemplateModel().getPreferences());
                XMLRecordsContainer oldContaienr = this.getTemplateModel().getRecordsContainer();
                this.getTemplateModel().updateContainer(container);
                for (XMLRecordContainerListener listener : oldContaienr.getListeners()) {
                    container.addRecordListener(listener);
                }
            }
            catch (InitializationException exc) {
                logger.warn(exc.getMessage());
                logger.logExceptionIfDebugEnabled(exc);
            }
        }
        for (File file : fileList) {
            if (file.isDirectory()) {
                File[] files;
                for (File subFile : files = file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith("xml");
                    }
                })) {
                    ((XMLFileRecordsContainer)this.getTemplateModel().getRecordsContainer()).addRecordWithoutNotification(subFile.getAbsolutePath(), true);
                }
                try {
                    this.getTemplateModel().getPreferences().addRecentRecord(file);
                }
                catch (BackingStoreException ignore) {}
                continue;
            }
            ((XMLFileRecordsContainer)this.getTemplateModel().getRecordsContainer()).addRecordWithoutNotification(file.getAbsolutePath(), false);
        }
        XMLRecordInterface currentRecord = ((XMLFileRecordsContainer)this.getTemplateModel().getRecordsContainer()).getCurrentRecord();
        if (currentRecord != null) {
            ((XMLFileRecordsContainer)this.getTemplateModel().getRecordsContainer()).notifyRecordAdded(currentRecord.getId());
            this.getTemplateModel().triggerUpdate();
            this.getTemplateModel().refresh();
            this.undoManager.discardAllEdits();
        }
    }

    @Override
    public boolean closeAllRecords() {
        if (this.getTemplateModel().getRecordsContainer() instanceof XMLFileRecordsContainer) {
            for (XMLRecordInterface record : this.getTemplateModel().getRecordsContainer().getAllRecords()) {
                if (this.closeRecord(record, false)) continue;
                this.getTemplateModel().triggerUpdate();
                this.getTemplateModel().refresh();
                return false;
            }
        } else {
            try {
                XMLFileRecordsContainer container = new XMLFileRecordsContainer(this.getTemplateModel(), this.getTemplateModel().getPreferences());
                XMLRecordsContainer oldContainer = this.getTemplateModel().getRecordsContainer();
                this.getTemplateModel().updateContainer(container);
                for (XMLRecordContainerListener listener : oldContainer.getListeners()) {
                    container.addRecordListener(listener);
                }
            }
            catch (InitializationException exc) {
                logger.warn(exc.getMessage());
                logger.logExceptionIfDebugEnabled(exc);
            }
        }
        this.getTemplateModel().triggerUpdate();
        this.getTemplateModel().refresh();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean closeRecord(XMLRecordInterface record, boolean refresh) {
        if (record.canSave() && record.isModified()) {
            int returnValue = this.getTemplateView().showConfirmDialog("Do you want to save the record before closing?");
            if (returnValue == 0) {
                if (record.isShowSaveAs()) {
                    String fileName = this.getTemplateView().showSaveAsDialog();
                    if (fileName == null) return false;
                    try {
                        record.saveRecord(fileName);
                        this.getTemplateModel().getPreferences().addRecentRecord(new File(fileName));
                    }
                    catch (Exception exc) {
                        logger.warn("Could not save record before closing %s", fileName);
                        logger.logExceptionIfDebugEnabled(exc);
                        this.getTemplateModel().addExecutionStatus(new ExceptionElement(exc));
                    }
                } else if (record instanceof XMLFileRecord) {
                    try {
                        ((XMLFileRecord)record).saveRecord();
                    }
                    catch (Exception exc) {
                        logger.warn("Could not save record before closing");
                        logger.logExceptionIfDebugEnabled(exc);
                        this.getTemplateModel().addExecutionStatus(new ExceptionElement(exc));
                    }
                }
            } else if (returnValue == 2) {
                return false;
            }
        }
        this.templateModel.getRecordsContainer().closeRecord(record);
        if (!refresh) return true;
        this.getTemplateModel().triggerUpdate();
        this.getTemplateModel().refresh();
        return true;
    }

    @Override
    public void loadServerRecords(ServiceAddress serverAddress) {
        try {
            this.closeAllRecords();
            XMLServerRecordsContainer container = new XMLServerRecordsContainer(serverAddress, this.getTemplateModel());
            XMLRecordsContainer oldContaienr = this.getTemplateModel().getRecordsContainer();
            this.getTemplateModel().updateContainer(container);
            this.getTemplateModel().setServerAddress(serverAddress);
            for (XMLRecordContainerListener listener : oldContaienr.getListeners()) {
                container.addRecordListener(listener);
            }
            this.getTemplateModel().refresh();
        }
        catch (InitializationException exc) {
            this.getTemplateModel().addExecutionStatus(new ExceptionElement(exc));
        }
    }

    @Override
    public void saveAllRecords() {
        if (this.getTemplateModel().getRecordsContainer() instanceof XMLFileRecordsContainer) {
            XMLFileRecordsContainer container = (XMLFileRecordsContainer)this.getTemplateModel().getRecordsContainer();
            for (XMLRecordInterface record : container.getAllRecords()) {
                XMLFileRecord fileRecord = (XMLFileRecord)record;
                if (!fileRecord.canSave()) {
                    String fileName = this.getTemplateView().showSaveAsDialog();
                    if (fileName == null) continue;
                    try {
                        fileRecord.saveRecord(fileName);
                        this.getTemplateModel().getPreferences().addRecentRecord(new File(fileName));
                    }
                    catch (Exception exc) {
                        logger.warn("Could not save record. %s", exc.getMessage());
                        logger.logExceptionIfDebugEnabled(exc);
                        this.getTemplateModel().addExecutionStatus(new ExceptionElement(exc));
                    }
                    continue;
                }
                try {
                    fileRecord.saveRecord();
                }
                catch (Exception exc) {
                    logger.warn("Could not save record. %s", exc.getMessage());
                    logger.logExceptionIfDebugEnabled(exc);
                    this.getTemplateModel().addExecutionStatus(new ExceptionElement(exc));
                }
            }
        }
    }
}

