/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.controller;

import at.mrdevelopment.esl.template.editor.common.FieldType;
import at.mrdevelopment.esl.template.editor.controller.SimpleTemplateController;
import at.mrdevelopment.esl.template.editor.controller.undoredo.AbstractDesignUndoable;
import at.mrdevelopment.esl.template.editor.controller.undoredo.AddBarcodeFieldUndoable;
import at.mrdevelopment.esl.template.editor.controller.undoredo.AddDragAndDropImageUndoable;
import at.mrdevelopment.esl.template.editor.controller.undoredo.AddEllipseUndoable;
import at.mrdevelopment.esl.template.editor.controller.undoredo.AddImageFieldUndoable;
import at.mrdevelopment.esl.template.editor.controller.undoredo.AddLineUndoable;
import at.mrdevelopment.esl.template.editor.controller.undoredo.AddListFieldUndoable;
import at.mrdevelopment.esl.template.editor.controller.undoredo.AddRectUndoable;
import at.mrdevelopment.esl.template.editor.controller.undoredo.AddTextFieldUndoable;
import at.mrdevelopment.esl.template.editor.controller.undoredo.ChangeOptionUndoable;
import at.mrdevelopment.esl.template.editor.controller.undoredo.ChangeRootImageOptionUndoable;
import at.mrdevelopment.esl.template.editor.controller.undoredo.RemoveFieldUndoable;
import at.mrdevelopment.esl.template.editor.controller.undoredo.ResizeElementUndoable;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.esl.template.editor.model.XSLTemplateElement;
import at.mrdevelopment.esl.template.editor.view.DesignTemplateView;
import at.mrdevelopment.esl.template.editor.view.components.celleditor.TextEditor;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StringElement;
import at.mrdevelopment.toolkit.file.FileUtils;
import at.mrdevelopment.toolkit.gui.event.MoveDirection;
import at.mrdevelopment.toolkit.gui.options.OptionsTable;
import at.mrdevelopment.toolkit.gui.options.OptionsTableEntry;
import at.mrdevelopment.toolkit.gui.options.OptionsTableModel;
import at.mrdevelopment.toolkit.image.ImageSerializer;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.options.InvalidOptionValueException;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.tree.Path;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.table.TableCellEditor;

public class DesignTemplateController
extends SimpleTemplateController {
    static ESLLogger logger = ESLLogger.getLogger(DesignTemplateController.class);
    private ResizeElementUndoable currentResizeElementUndoable;

    public void startingToResizeElement(int fieldId) {
        Shape elementBoundsBeforeResize = ((DesignTemplateModel)this.templateModel).getTemplate().getFieldBounds(fieldId);
        this.currentResizeElementUndoable = new ResizeElementUndoable((DesignTemplateModel)this.templateModel, fieldId, elementBoundsBeforeResize, elementBoundsBeforeResize);
    }

    public void resizeElement(int fieldId, Shape shape) {
        if (this.currentResizeElementUndoable == null) {
            return;
        }
        this.currentResizeElementUndoable.setNewShape(shape);
        try {
            this.currentResizeElementUndoable.perform();
        }
        catch (OptionException exc) {
            logger.warn("Error resizing field %d, %s: %s", fieldId, shape.toString(), exc.getMessage());
            logger.logExceptionIfDebugEnabled(exc);
        }
    }

    public void finishedResizingElement() {
        if (this.currentResizeElementUndoable == null) {
            return;
        }
        this.undoManager.addEdit(this.currentResizeElementUndoable);
        this.currentResizeElementUndoable = null;
    }

    public void optionChanged(int fieldId, Path optionPath, String value) {
        ChangeOptionUndoable changeOptionUndoable = new ChangeOptionUndoable(this, (DesignTemplateModel)this.templateModel, fieldId, optionPath, value);
        this.undoManager.addEdit(changeOptionUndoable);
        changeOptionUndoable.perform();
    }

    public void rootOptionChanged(Path optionPath, String value) {
        ChangeRootImageOptionUndoable rootImageOptionUndoable = new ChangeRootImageOptionUndoable(this, (DesignTemplateModel)this.templateModel, optionPath, value);
        this.undoManager.addEdit(rootImageOptionUndoable);
        rootImageOptionUndoable.perform();
    }

    public AddBarcodeFieldUndoable createBarcodeUndoable() {
        AddBarcodeFieldUndoable addBarcodeFieldUndoable = new AddBarcodeFieldUndoable((DesignTemplateModel)this.templateModel);
        return addBarcodeFieldUndoable;
    }

    public void perform(AbstractDesignUndoable undoable) {
        this.undoManager.addEdit(undoable);
        undoable.perform();
    }

    public AddTextFieldUndoable createTextFieldUndoable() {
        return new AddTextFieldUndoable((DesignTemplateModel)this.templateModel);
    }

    public AbstractDesignUndoable createListFieldUndoable() {
        return new AddListFieldUndoable((DesignTemplateModel)this.templateModel);
    }

    public AddImageFieldUndoable createImageFieldUndoable() {
        return new AddImageFieldUndoable((DesignTemplateModel)this.templateModel);
    }

    public void removeField(int fieldId, boolean force) {
        if (!((DesignTemplateModel)this.templateModel).isFieldSafeToDelete(fieldId) && !force) {
            return;
        }
        RemoveFieldUndoable removeFieldUndoable = new RemoveFieldUndoable((DesignTemplateModel)this.templateModel, fieldId);
        this.undoManager.addEdit(removeFieldUndoable);
        removeFieldUndoable.perform();
    }

    public AddLineUndoable createLineUndoable() {
        return new AddLineUndoable((DesignTemplateModel)this.templateModel);
    }

    public AddRectUndoable createRectUndoable() {
        return new AddRectUndoable((DesignTemplateModel)this.templateModel);
    }

    public AddEllipseUndoable createEllipseUndoable() {
        return new AddEllipseUndoable((DesignTemplateModel)this.templateModel);
    }

    public void finishedInsertingElement(AbstractDesignUndoable currentInsertUndoable) {
        this.undoManager.addEdit(currentInsertUndoable);
    }

    public void handleDoubleClickOnField(int fieldId) {
        FieldType fieldType;
        String actionText;
        if (fieldId >= 0 && (actionText = FieldType.getPrimaryActionText(fieldType = ((DesignTemplateModel)this.templateModel).getFieldType(fieldId))) != null && !actionText.isEmpty()) {
            OptionsTable table = ((DesignTemplateView)this.getTemplateView()).getOptionsTable();
            OptionsTableModel model = (OptionsTableModel)table.getModel();
            for (int i = 0; i < model.getAllRows().size(); ++i) {
                TableCellEditor cellEditor;
                OptionsTableEntry entry = model.getAllRows().get(i);
                if (!entry.getId().equals(actionText) || !((cellEditor = table.getCellEditor(i, 1)) instanceof TextEditor)) continue;
                ((TextEditor)cellEditor).triggerAction();
            }
        }
    }

    public void handleInvalidOption(ChangeOptionUndoable changeOptionUndoable, InvalidOptionValueException exception) {
        String message = String.format("'%s' is not a valid value for property '%s'. Possible values: %s", exception.getValue(), exception.getOptionPath().getLastElement(), exception.getPossibleValues());
        StringElement element = new StringElement(message, ExecutionStatusElement.ErrorLevel.ERROR);
        ((DesignTemplateModel)this.templateModel).refreshOnDesignAction();
        this.templateModel.addExecutionStatus(element, true);
    }

    public void handleDragAndDrop(List<File> files) {
        for (File file : files) {
            try {
                BufferedImage image = ImageIO.read(file);
                String base64String = ImageSerializer.toBase64String(image);
                Rectangle bounds = new Rectangle(image.getWidth(), image.getHeight());
                if (base64String.length() < 65535) {
                    AddDragAndDropImageUndoable undoable = new AddDragAndDropImageUndoable((DesignTemplateModel)this.templateModel, base64String, true, bounds);
                    undoable.perform();
                    this.undoManager.addEdit(undoable);
                    continue;
                }
                File workingDirectory = ((DesignTemplateModel)this.templateModel).getWorkingDirectory();
                if (workingDirectory != null) {
                    String relativePath = FileUtils.getRelativePath(file.getAbsolutePath(), workingDirectory.getAbsolutePath(), System.getProperty("file.separator"));
                    AddDragAndDropImageUndoable undoable = new AddDragAndDropImageUndoable((DesignTemplateModel)this.templateModel, relativePath, false, bounds);
                    undoable.perform();
                    this.undoManager.addEdit(undoable);
                    continue;
                }
                this.templateModel.addExecutionStatus(new StringElement(String.format("Please save template before inserting file %s.", file.getName()), ExecutionStatusElement.ErrorLevel.ERROR), true);
            }
            catch (Exception exc) {
                String message = String.format("Could not insert image file %s: %s", file.getName(), exc.getMessage());
                logger.warn(message);
                logger.logExceptionIfDebugEnabled(exc);
                this.templateModel.addExecutionStatus(new StringElement(message, ExecutionStatusElement.ErrorLevel.ERROR), true);
            }
        }
    }

    public void moveField(int fieldId, MoveDirection direction) {
        if (fieldId >= 0) {
            XSLTemplateElement field = ((DesignTemplateModel)this.templateModel).getField(fieldId);
            Shape bounds = field.getBounds();
            AffineTransform transform = MoveDirection.getTransformation(direction, 1.0);
            Shape transformedShape = transform.createTransformedShape(bounds);
            try {
                ((DesignTemplateModel)this.templateModel).setFieldBounds(fieldId, transformedShape);
            }
            catch (OptionException exc) {
                logger.warn(exc.getMessage());
                logger.logExceptionIfDebugEnabled(exc);
            }
        }
    }
}

