/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.common;

import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.toolkit.InitializationException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.lang.BooleanUtils;

public class TemplateEditorPreferences {
    private static final String ROOT_NODE_NAME = "iMAGOTAG Template Editor";
    private static final String CONFIGURATION_NODE_NAME = "Configuration";
    private static final String RECENT_TEMPLATES_NODE_NAME = "Recent Templates";
    private static final String RECENT_RECORDS_NODE_NAME = "Recent Records";
    private static final String DESIGN_MODE_ENABLED_KEY = "Design Mode Enabled";
    private static final String SERVICE_ADDRESSES_NODE_NAME = "ServiceAddresses";
    private static final int DEFAULT_MAX_RECENT_COUNT = 10;
    private static final String RECENT_PREFIX = "Recent_";
    private Preferences rootNode;
    private Preferences configurationNode;
    private Preferences recentTemplatesNode;
    private Preferences recentRecordsNode;
    private Preferences recentServiceAddressesNode;
    private boolean designModeEnabled;
    private List<String> recentTemplates;
    private List<String> recentRecords;
    private Collection<ServiceAddress> serviceAddresses;

    public TemplateEditorPreferences() throws InitializationException {
        try {
            this.rootNode = Preferences.userRoot().node(ROOT_NODE_NAME);
            this.configurationNode = this.rootNode.node(CONFIGURATION_NODE_NAME);
            this.recentServiceAddressesNode = this.rootNode.node(SERVICE_ADDRESSES_NODE_NAME);
            this.serviceAddresses = new HashSet<ServiceAddress>();
            for (String name : this.recentServiceAddressesNode.keys()) {
                this.serviceAddresses.add(ServiceAddress.fromString((String)name));
            }
            String designModeEnabledString = this.configurationNode.get(DESIGN_MODE_ENABLED_KEY, null);
            this.designModeEnabled = designModeEnabledString != null ? BooleanUtils.toBoolean((String)designModeEnabledString) : true;
            this.recentTemplatesNode = this.rootNode.node(RECENT_TEMPLATES_NODE_NAME);
            this.recentTemplates = new ArrayList<String>();
            for (String name : this.recentTemplatesNode.keys()) {
                if (!name.startsWith(RECENT_PREFIX)) continue;
                this.recentTemplates.add(this.recentTemplatesNode.get(name, null));
            }
            this.recentRecordsNode = this.rootNode.node(RECENT_RECORDS_NODE_NAME);
            this.recentRecords = new ArrayList<String>();
            for (String name : this.recentRecordsNode.keys()) {
                if (!name.startsWith(RECENT_PREFIX)) continue;
                this.recentRecords.add(this.recentRecordsNode.get(name, null));
            }
        }
        catch (Exception exc) {
            throw new InitializationException(exc);
        }
    }

    public boolean isDesignModeEnabled() {
        return this.designModeEnabled;
    }

    public void storeDesignModeEnabled(boolean enabled) throws BackingStoreException {
        this.designModeEnabled = enabled;
        this.configurationNode.put(DESIGN_MODE_ENABLED_KEY, String.valueOf(enabled));
        this.configurationNode.flush();
    }

    public List<String> getRecentRecords() {
        return this.recentRecords;
    }

    public List<String> getRecentTemplates() {
        return this.recentTemplates;
    }

    public void addRecentTemplate(File templateFile) throws BackingStoreException {
        this.addRecentEntry(templateFile, this.recentTemplates, this.recentTemplatesNode);
    }

    public void addRecentRecord(File recordFile) throws BackingStoreException {
        this.addRecentEntry(recordFile, this.recentRecords, this.recentRecordsNode);
    }

    private void addRecentEntry(File entry, List<String> list, Preferences node) throws BackingStoreException {
        String name = entry.getAbsolutePath();
        if (!list.contains(name)) {
            if (list.size() >= 10) {
                String removedFile = list.remove(0);
                node.remove(removedFile);
            }
            list.add(name);
            this.addRecentEntry(list, node);
        }
    }

    private void addRecentEntry(List<String> list, Preferences node) throws BackingStoreException {
        for (int i = 0; i < list.size(); ++i) {
            node.put(RECENT_PREFIX + String.valueOf(i), list.get(i));
        }
        node.flush();
    }

    public void removeRecentRecord(File recordFile) throws BackingStoreException {
        this.removeRecentEntry(recordFile.getAbsolutePath(), this.recentRecords, this.recentRecordsNode);
    }

    public void removeRecentTemplate(File templateFile) throws BackingStoreException {
        this.removeRecentEntry(templateFile.getAbsolutePath(), this.recentTemplates, this.recentTemplatesNode);
    }

    private void removeRecentEntry(String entry, List<String> list, Preferences node) throws BackingStoreException {
        list.remove(entry);
        node.remove(entry);
    }

    public void addServiceAddress(ServiceAddress serviceAddress) {
        if (this.serviceAddresses.add(serviceAddress)) {
            this.recentServiceAddressesNode.put(serviceAddress.toString(), serviceAddress.toString());
        }
    }

    public void setServiceAddresses(Collection<ServiceAddress> newServiceAddresses) throws BackingStoreException {
        this.serviceAddresses.clear();
        this.serviceAddresses.addAll(newServiceAddresses);
        this.recentServiceAddressesNode.clear();
        for (ServiceAddress serviceAddress : this.serviceAddresses) {
            this.recentServiceAddressesNode.put(serviceAddress.toString(), serviceAddress.toString());
        }
    }

    public Collection<ServiceAddress> getRecentServiceAddresses() {
        return this.serviceAddresses;
    }
}

