/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.common;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateDesignValidator {
    static ESLLogger logger = ESLLogger.getLogger(TemplateDesignValidator.class);
    private static Map<String, Integer> allowedElements = new HashMap<String, Integer>();
    private Map<String, Integer> currentElements = new HashMap<String, Integer>();
    private XMLToolkit xmlToolkit = new XMLToolkit();

    public boolean validate(InputStream inputStream) {
        this.currentElements.clear();
        try {
            Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
            this.currentElements.put(root.getNodeName(), 1);
            NodeList allElements = root.getElementsByTagName("*");
            for (int index = 0; index < allElements.getLength(); ++index) {
                Node node = allElements.item(index);
                if (!this.currentElements.containsKey(node.getNodeName())) {
                    this.currentElements.put(node.getNodeName(), 0);
                }
                int count = this.currentElements.get(node.getNodeName());
                this.currentElements.put(node.getNodeName(), ++count);
            }
            for (String key : this.currentElements.keySet()) {
                if (!allowedElements.containsKey(key)) {
                    return false;
                }
                if (allowedElements.get(key) <= 0 || this.currentElements.get(key) <= allowedElements.get(key)) continue;
                return false;
            }
            return true;
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
            return false;
        }
    }

    static {
        allowedElements.put("xsl:stylesheet", 1);
        allowedElements.put("xsl:template", 1);
        allowedElements.put("image", 0);
        allowedElements.put("line", 0);
        allowedElements.put("rect", 0);
        allowedElements.put("img", 0);
        allowedElements.put("ellipse", 0);
        allowedElements.put("field", 0);
        allowedElements.put("text", 0);
        allowedElements.put("ul", 0);
        allowedElements.put("ol", 0);
        allowedElements.put("li", 0);
        allowedElements.put("barcode", 0);
        allowedElements.put("xsl:value-of", 0);
        allowedElements.put("xsl:attribute", 0);
        allowedElements.put("br", 0);
    }
}

