/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor.common;

import at.mrdevelopment.esl.template.editor.common.TemplateAttributeParameter;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.Example;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.fife.rsta.ac.html.HtmlCompletionProvider;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.MarkupTagCompletion;

public class TemplateCompletionProvider
extends HtmlCompletionProvider {
    static ESLLogger logger = ESLLogger.getLogger(TemplateCompletionProvider.class);
    private List<Completion> completionList;

    protected void initCompletions() {
        this.completionList = new ArrayList<Completion>();
        File autoCompleteFolder = new File("data/help/autocomplete");
        if (!autoCompleteFolder.exists()) {
            autoCompleteFolder.mkdirs();
        }
        for (TemplateNode templateNode : TemplateNode.values()) {
            if (templateNode.toString().startsWith("BARCODE") || templateNode.equals((Object)TemplateNode.PLAIN_TEXT)) continue;
            MarkupTagCompletion completion = new MarkupTagCompletion((CompletionProvider)this, templateNode.getKey());
            StringBuilder builder = new StringBuilder();
            builder.append(templateNode.getDescription());
            builder = this.createElementDescriptionString(builder, templateNode.name().toUpperCase(), templateNode.getKey(), autoCompleteFolder);
            if (templateNode.getExamples() != null && templateNode.getExamples().length > 0) {
                builder.append("<br/><b>Example(s):</b><br/>");
                for (Example example : templateNode.getExamples()) {
                    builder = this.createExampleDescriptionString(builder, example, autoCompleteFolder, "<br/>");
                }
            }
            completion.setDescription(builder.toString());
            ArrayList<TemplateAttributeParameter> attributes = new ArrayList<TemplateAttributeParameter>();
            for (int i = 0; i < templateNode.getAttributeList().size(); ++i) {
                Attribute attribute = templateNode.getAttributeList().get(i);
                TemplateAttributeParameter parameter = new TemplateAttributeParameter(attribute.getValueClass().getName(), attribute.getKey());
                StringBuilder descriptionBuilder = new StringBuilder();
                descriptionBuilder.append(attribute.getDescription().getDescription());
                descriptionBuilder.append("<br/><br/><i>Possible value(s):</i><br/>");
                descriptionBuilder.append(attribute.getDescription().getPossibleValueDescription());
                if (attribute.getExamples() != null && attribute.getExamples().length > 0) {
                    descriptionBuilder.append("<br/><br/><i>Example(s):</i><br/>");
                    for (Example example : attribute.getExamples()) {
                        descriptionBuilder = this.createExampleDescriptionString(descriptionBuilder, example, autoCompleteFolder, "");
                    }
                }
                descriptionBuilder.append("<br/>");
                parameter.setDescription(descriptionBuilder.toString());
                attributes.add(parameter);
            }
            Collections.sort(attributes);
            completion.setAttributes(attributes);
            this.completionList.add((Completion)completion);
        }
        super.addCompletions(this.completionList);
    }

    public List<Completion> getCompletions() {
        return this.completionList;
    }

    private StringBuilder createElementDescriptionString(StringBuilder stringBuilder, String elementId, String elementName, File autoCompleteFolder) {
        String fileName = elementId + ".html";
        String url = new File("data/help/elements.xml").getAbsolutePath() + "?element=" + elementId;
        this.createDummyHtmlFile(fileName, url);
        stringBuilder.append("<br/><br/><b>See:</b><br/> <a href=\"file:///");
        stringBuilder.append(new File(autoCompleteFolder, fileName).getAbsolutePath());
        stringBuilder.append("\">");
        stringBuilder.append(elementName);
        stringBuilder.append("</a><br/>");
        return stringBuilder;
    }

    private StringBuilder createExampleDescriptionString(StringBuilder stringBuilder, Example example, File autoCompleteFolder, String suffix) {
        String fileName = example.getId() + ".html";
        String url = new File("data/help/examples.xml").getAbsolutePath() + "?id=" + example.getId();
        this.createDummyHtmlFile(fileName, url);
        stringBuilder.append("<a href=\"file:///");
        stringBuilder.append(new File(autoCompleteFolder, fileName).getAbsolutePath());
        stringBuilder.append("\">");
        stringBuilder.append(example.getTitle());
        stringBuilder.append("</a>");
        stringBuilder.append(suffix);
        return stringBuilder;
    }

    private void createDummyHtmlFile(String fileName, String url) {
        StringBuilder builder = new StringBuilder();
        builder.append("<html><head><meta http-equiv=\"refresh\" content=\"0;URL='file:///");
        builder.append(url);
        builder.append("'\"></meta></head></html>");
        try {
            FileUtils.writeStringToFile((File)new File("data/help/autocomplete/" + fileName), (String)builder.toString());
        }
        catch (IOException exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
    }

    protected boolean isValidChar(char ch) {
        return super.isValidChar(ch) || ch == '-';
    }
}

