/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.editor;

import at.mrdevelopment.esl.template.editor.controller.DesignTemplateController;
import at.mrdevelopment.esl.template.editor.model.DesignTemplateModel;
import at.mrdevelopment.esl.template.editor.view.DesignTemplateView;
import at.mrdevelopment.esl.template.editor.view.TemplateView;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.gui.GUIUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.text.ESLFontLoader;
import javax.swing.SwingUtilities;

public class TemplateEditor {
    public static final String APPLICATION_NAME = "imagotag Template Editor";
    public static final String APPLICATION_TITLE = "Template Editor";

    public TemplateEditor(String[] args) throws InitializationException {
        GUIUtils.setSystemLookAndFeel();
        new ESLFontLoader();
        DesignTemplateModel templateModel = new DesignTemplateModel();
        DesignTemplateController templateController = new DesignTemplateController();
        templateController.setTemplateModel(templateModel);
        DesignTemplateView templateView = new DesignTemplateView(templateController, templateModel);
        templateController.setTemplateView(templateView);
        templateModel.init();
        ((TemplateView)templateView).show();
    }

    public static void main(final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    GUIUtils.setSystemLookAndFeel();
                    new TemplateEditor(args);
                }
                catch (InitializationException exc) {
                    exc.printStackTrace();
                }
            }
        });
    }

    static {
        ESLLogger.initLogger(true);
    }
}

