/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.security.Puk;
import at.mrdevelopment.esl.tasks.BinaryImageTask;
import at.mrdevelopment.esl.tasks.FirmwareTask;
import at.mrdevelopment.esl.tasks.ForceUpdateTask;
import at.mrdevelopment.esl.tasks.ImageTask;
import at.mrdevelopment.esl.tasks.PingTask;
import at.mrdevelopment.esl.tasks.RefreshDisplayTask;
import at.mrdevelopment.esl.tasks.ResendTask;
import at.mrdevelopment.esl.tasks.ResetImageTask;
import at.mrdevelopment.esl.tasks.ResetTask;
import at.mrdevelopment.esl.tasks.SwitchPageTask;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.tasks.TemplateValuesTask;
import at.mrdevelopment.esl.tasks.TemplateXMLTask;
import at.mrdevelopment.esl.tasks.UnlockLabelTask;
import at.mrdevelopment.esl.template.DOMTemplateSource;
import at.mrdevelopment.esl.template.FileTemplateSource;
import at.mrdevelopment.esl.template.TemplateSource;
import at.mrdevelopment.esl.type.TaskOrder;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.image.ImageSerializer;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TaskXMLSerializer
implements XMLSerializer<Task> {
    static ESLLogger logger = ESLLogger.getLogger(TaskXMLSerializer.class);
    private static final String XSD = "import.xsd";
    private final XMLToolkit xmlToolkit = new XMLToolkit("import.xsd");

    public Document toXML(TaskOrder taskOrder) throws SerializeException {
        Document document = this.xmlToolkit.newDocument();
        Element list = document.createElement("tasks");
        if (taskOrder.getTitle() != null) {
            list.setAttribute("title", taskOrder.getTitle());
        }
        if (taskOrder.getExternalId() != 0L) {
            list.setAttribute("externalId", Long.toString(taskOrder.getExternalId()));
        }
        for (Task task : taskOrder.getTasks()) {
            list.appendChild(this.taskToXML(document, task));
        }
        document.appendChild(list);
        return document;
    }

    public Document toXML(Task task) throws SerializeException {
        Document document = this.xmlToolkit.newDocument();
        Element list = document.createElement("tasks");
        list.appendChild(this.taskToXML(document, task));
        document.appendChild(list);
        return document;
    }

    private Element taskToXML(Document document, Task task) throws SerializeException {
        Element taskElement = document.createElement("task");
        taskElement.setAttribute("id", Long.toString(task.getExternalId()));
        taskElement.setAttribute("label", task.getLabelId().getLabelIdString());
        taskElement.setAttribute("priority", task.getPriority().toString());
        taskElement.setAttribute("replace", Boolean.toString(task.isReplaceWaitingTasks()));
        if (task instanceof TemplateXMLTask) {
            Element element = this.templateXMLTaskToXML(document, (TemplateXMLTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof TemplateValuesTask) {
            Element element = this.templateValuesTaskToXML(document, (TemplateValuesTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof ImageTask) {
            Element element = this.imageTaskToXML(document, (ImageTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof BinaryImageTask) {
            Element element = this.binaryImageTaskToXML(document, (BinaryImageTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof ResetTask) {
            Element element = this.resetTaskToXML(document, (ResetTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof ResendTask) {
            Element element = this.resendTaskToXML(document, (ResendTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof FirmwareTask) {
            Element element = this.firmwareTaskToXML(document, (FirmwareTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof SwitchPageTask) {
            Element element = this.switchPageTaskToXML(document, (SwitchPageTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof RefreshDisplayTask) {
            Element element = this.refreshDisplayTaskToXML(document, (RefreshDisplayTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof ForceUpdateTask) {
            Element element = this.forceUpdateTaskToXML(document, (ForceUpdateTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof PingTask) {
            Element element = this.pingTaskToXML(document, (PingTask)task);
            taskElement.appendChild(element);
        } else if (task instanceof UnlockLabelTask) {
            Element element = this.unlockLabelTaskToXML(document, (UnlockLabelTask)task);
            taskElement.appendChild(element);
        } else {
            throw new SerializeException("Could not serialize unknown task type %s", new Object[]{task.getClass().getSimpleName()});
        }
        return taskElement;
    }

    private Element templateValuesTaskToXML(Document document, TemplateValuesTask task) throws SerializeException {
        Element taskElement = document.createElement("values-template-task");
        taskElement = this.templateSourceToXML(document, taskElement, task.getTemplateSource());
        taskElement.setAttribute("page", Integer.toString(task.getPage().getPageIndex()));
        taskElement.setAttribute("preload", Boolean.toString(task.isPreload()));
        Element valuesElement = document.createElement("values");
        taskElement.appendChild(valuesElement);
        for (Map.Entry<String, String> entry : task.getValues().entrySet()) {
            Element element = document.createElement("value");
            element.setAttribute("key", entry.getKey());
            element.setTextContent(entry.getValue());
            valuesElement.appendChild(element);
        }
        return taskElement;
    }

    private Element templateXMLTaskToXML(Document document, TemplateXMLTask task) throws SerializeException {
        Element taskElement = document.createElement("xml-template-task");
        taskElement = this.templateSourceToXML(document, taskElement, task.getTemplateSource());
        taskElement.setAttribute("page", Integer.toString(task.getPage().getPageIndex()));
        taskElement.setAttribute("preload", Boolean.toString(task.isPreload()));
        Node importedNode = document.importNode(task.getDocument().getDocumentElement(), true);
        taskElement.appendChild(importedNode);
        return taskElement;
    }

    private Element templateSourceToXML(Document document, Element taskElement, TemplateSource templateSource) throws SerializeException {
        if (templateSource instanceof FileTemplateSource) {
            FileTemplateSource fileTemplateSource = (FileTemplateSource)templateSource;
            taskElement.setAttribute("template", fileTemplateSource.getTemplateFilename());
        } else if (templateSource instanceof DOMTemplateSource) {
            Element templateSourceElement = document.createElement("templateSource");
            DOMTemplateSource domTemplateSource = (DOMTemplateSource)templateSource;
            Node sourceNode = domTemplateSource.getSource().getNode();
            if (sourceNode instanceof Document) {
                sourceNode = ((Document)sourceNode).getDocumentElement();
            }
            sourceNode = document.importNode(sourceNode, true);
            templateSourceElement.appendChild(sourceNode);
            taskElement.appendChild(templateSourceElement);
        }
        return taskElement;
    }

    private Element imageTaskToXML(Document document, ImageTask task) {
        Element taskElement = document.createElement("image-task");
        taskElement.setAttribute("file", task.getImageFilename());
        taskElement.setAttribute("page", Integer.toString(task.getPage().getPageIndex()));
        taskElement.setAttribute("preload", Boolean.toString(task.isPreload()));
        return taskElement;
    }

    private Element binaryImageTaskToXML(Document document, BinaryImageTask task) throws SerializeException {
        Element taskElement = document.createElement("binary-image-task");
        taskElement.setAttribute("image", ImageSerializer.toBase64String((BufferedImage)task.getImage()));
        taskElement.setAttribute("page", Integer.toString(task.getPage().getPageIndex()));
        taskElement.setAttribute("preload", Boolean.toString(task.isPreload()));
        return taskElement;
    }

    private Element resetTaskToXML(Document document, ResetTask task) {
        Element taskElement = document.createElement("reset-task");
        return taskElement;
    }

    private Element resendTaskToXML(Document document, ResendTask task) {
        Element taskElement = document.createElement("resend-task");
        taskElement.setAttribute("task-id", task.getTaskId().toString());
        return taskElement;
    }

    private Element firmwareTaskToXML(Document document, FirmwareTask task) {
        Element taskElement = document.createElement("firmware-task");
        taskElement.setAttribute("file", task.getFirmwareFilename());
        return taskElement;
    }

    private Element switchPageTaskToXML(Document document, SwitchPageTask task) {
        Element taskElement = document.createElement("switch-page-task");
        taskElement.setAttribute("page", Integer.toString(task.getPage().getPageIndex()));
        return taskElement;
    }

    private Element refreshDisplayTaskToXML(Document document, RefreshDisplayTask task) {
        Element taskElement = document.createElement("refresh-display-task");
        return taskElement;
    }

    private Element forceUpdateTaskToXML(Document document, ForceUpdateTask task) {
        Element taskElement = document.createElement("force-update-task");
        return taskElement;
    }

    private Element pingTaskToXML(Document document, PingTask task) {
        Element taskElement = document.createElement("ping-task");
        return taskElement;
    }

    private Element unlockLabelTaskToXML(Document document, UnlockLabelTask task) {
        Element taskElement = document.createElement("unlock-task");
        taskElement.setAttribute("puk", task.getPuk().toBase64());
        return taskElement;
    }

    public Collection<Task> parseXMLFromFile(File xmlFile, File templateDirectory) throws SerializeException {
        try {
            Element root = this.xmlToolkit.getDocumentRootFromFile(xmlFile);
            return this.parseTasks(root, templateDirectory);
        }
        catch (IOException exc) {
            throw new SerializeException((Throwable)exc);
        }
        catch (NumberFormatException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public TaskOrder parseXMLFromStream(InputStream xmlInputStream, File templateDirectory) throws SerializeException {
        try {
            Element root = this.xmlToolkit.getDocumentRootFromInputStream(xmlInputStream);
            String title = root.getAttribute("title");
            long externalId = root.hasAttribute("externalId") ? Long.parseLong(root.getAttribute("externalId")) : 0L;
            List<Task> tasks = this.parseTasks(root, templateDirectory);
            return new TaskOrder(title, externalId, tasks);
        }
        catch (RuntimeException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    private List<Task> parseTasks(Element root, File templateDirectory) throws SerializeException, NumberFormatException, IllegalArgumentException {
        ArrayList<Task> tasks = new ArrayList<Task>();
        NodeList taskNodes = root.getElementsByTagName("task");
        for (int index = 0; index < taskNodes.getLength(); ++index) {
            Element taskElement = (Element)taskNodes.item(index);
            Task task = this.parseTask(taskElement, templateDirectory);
            tasks.add(task);
        }
        return tasks;
    }

    private Task parseTask(Element element, File templateDirectory) throws SerializeException, NumberFormatException, IllegalArgumentException {
        LabelId labelId = LabelId.fromString(element.getAttribute("label"));
        TaskPriority priority = element.hasAttribute("priority") ? TaskPriority.valueOf((String)element.getAttribute("priority")) : TaskPriority.NORMAL;
        long externalId = element.hasAttribute("id") ? Long.parseLong(element.getAttribute("id")) : 0L;
        boolean replaceWaitingTasks = element.hasAttribute("replace") ? Boolean.valueOf(element.getAttribute("replace")) : false;
        NodeList templateValuesNodes = element.getElementsByTagName("values-template-task");
        NodeList templateXMLNodes = element.getElementsByTagName("xml-template-task");
        NodeList imageNodes = element.getElementsByTagName("image-task");
        NodeList binaryImageNodes = element.getElementsByTagName("binary-image-task");
        NodeList resetNodes = element.getElementsByTagName("reset-task");
        NodeList resetImageNodes = element.getElementsByTagName("reset-image-task");
        NodeList resendNodes = element.getElementsByTagName("resend-task");
        NodeList firmwareNodes = element.getElementsByTagName("firmware-task");
        NodeList switchPageNodes = element.getElementsByTagName("switch-page-task");
        NodeList refreshDisplayNodes = element.getElementsByTagName("refresh-display-task");
        NodeList forceUpdateNodes = element.getElementsByTagName("force-update-task");
        NodeList pingNodes = element.getElementsByTagName("ping-task");
        NodeList unlockLabelNodes = element.getElementsByTagName("unlock-task");
        if (templateValuesNodes.getLength() > 0) {
            return this.parseTemplateValuesTask(labelId, priority, externalId, replaceWaitingTasks, (Element)templateValuesNodes.item(0), templateDirectory);
        }
        if (templateXMLNodes.getLength() > 0) {
            return this.parseTemplateXMLTask(labelId, priority, externalId, replaceWaitingTasks, (Element)templateXMLNodes.item(0), templateDirectory);
        }
        if (imageNodes.getLength() > 0) {
            return this.parseImageTask(labelId, priority, externalId, replaceWaitingTasks, (Element)imageNodes.item(0));
        }
        if (binaryImageNodes.getLength() > 0) {
            return this.parseBinaryImageTask(labelId, priority, externalId, replaceWaitingTasks, (Element)binaryImageNodes.item(0));
        }
        if (resetNodes.getLength() > 0) {
            return this.parseResetTask(labelId, priority, externalId, replaceWaitingTasks, (Element)resetNodes.item(0));
        }
        if (resetImageNodes.getLength() > 0) {
            return this.parseResetImageTask(labelId, priority, externalId, replaceWaitingTasks, (Element)resetImageNodes.item(0));
        }
        if (resendNodes.getLength() > 0) {
            return this.parseResendTask(labelId, priority, externalId, replaceWaitingTasks, (Element)resendNodes.item(0));
        }
        if (firmwareNodes.getLength() > 0) {
            return this.parseFirmwareTask(labelId, priority, externalId, replaceWaitingTasks, (Element)firmwareNodes.item(0));
        }
        if (switchPageNodes.getLength() > 0) {
            return this.parseSwitchPageTask(labelId, priority, externalId, replaceWaitingTasks, (Element)switchPageNodes.item(0));
        }
        if (refreshDisplayNodes.getLength() > 0) {
            return this.refreshDisplayTask(labelId, priority, externalId, replaceWaitingTasks, (Element)refreshDisplayNodes.item(0));
        }
        if (forceUpdateNodes.getLength() > 0) {
            return this.forceUpdateTask(labelId, priority, externalId, replaceWaitingTasks, (Element)forceUpdateNodes.item(0));
        }
        if (pingNodes.getLength() > 0) {
            return this.pingTask(labelId, priority, externalId, replaceWaitingTasks, (Element)pingNodes.item(0));
        }
        if (unlockLabelNodes.getLength() > 0) {
            return this.unlockLabelTask(labelId, priority, externalId, replaceWaitingTasks, (Element)unlockLabelNodes.item(0));
        }
        throw new SerializeException("Unexpected task type", new Object[0]);
    }

    private Task parseTemplateValuesTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, File templateDirectory) throws SerializeException {
        TemplateSource templateSource = this.parseTemplateSource(element, templateDirectory);
        Page page = Page.fromString((String)element.getAttribute("page"));
        boolean preload = Boolean.parseBoolean(element.getAttribute("preload"));
        NodeList valueNodes = element.getElementsByTagName("value");
        HashMap<String, String> values = new HashMap<String, String>();
        for (int index = 0; index < valueNodes.getLength(); ++index) {
            Element valueElement = (Element)valueNodes.item(index);
            String key = valueElement.getAttribute("key");
            String value = valueElement.getTextContent();
            values.put(key, value);
        }
        return new TemplateValuesTask(labelId, priority, externalId, replaceWaitingTasks, templateSource, values, page, preload);
    }

    private Task parseTemplateXMLTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element, File templateDirectory) throws SerializeException {
        TemplateSource templateSource = this.parseTemplateSource(element, templateDirectory);
        Page page = Page.fromString((String)element.getAttribute("page"));
        boolean preload = Boolean.parseBoolean(element.getAttribute("preload"));
        Document document = this.xmlToolkit.newDocument();
        NodeList nodes = element.getChildNodes();
        for (int index = 0; index < nodes.getLength(); ++index) {
            Node node = nodes.item(index);
            if (!(node instanceof Element)) continue;
            Node importedNode = document.importNode(node, true);
            document.appendChild(importedNode);
        }
        return new TemplateXMLTask(labelId, priority, externalId, replaceWaitingTasks, templateSource, document, page, preload);
    }

    private TemplateSource parseTemplateSource(Element element, File templateDirectory) throws SerializeException {
        if (element.hasAttribute("template")) {
            String templateName = element.getAttribute("template");
            return new FileTemplateSource(templateDirectory, templateName);
        }
        NodeList templateSourceElement = element.getElementsByTagName("templateSource");
        if (templateSourceElement.getLength() > 0 && templateSourceElement.item(0).hasChildNodes()) {
            NodeList childNodes = templateSourceElement.item(0).getChildNodes();
            for (int index = 0; index < childNodes.getLength(); ++index) {
                Node childNode = childNodes.item(index);
                if (childNode.getNodeType() != 1) continue;
                Document templateDocument = this.xmlToolkit.newDocument();
                templateDocument.appendChild(templateDocument.importNode(childNode, true));
                DOMTemplateSource domTemplateSource = new DOMTemplateSource(templateDirectory, new DOMSource(templateDocument));
                element.removeChild(templateSourceElement.item(0));
                return domTemplateSource;
            }
        }
        throw new SerializeException("No template source found in XML", new Object[0]);
    }

    private ImageTask parseImageTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element) {
        String imageFilename = element.getAttribute("file");
        Page page = Page.fromString((String)element.getAttribute("page"));
        boolean preload = Boolean.parseBoolean(element.getAttribute("preload"));
        return new ImageTask(labelId, priority, externalId, replaceWaitingTasks, imageFilename, page, preload);
    }

    private BinaryImageTask parseBinaryImageTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element) throws NumberFormatException, SerializeException {
        BufferedImage image = ImageSerializer.fromBase64String((String)element.getAttribute("image"));
        Page page = Page.fromString((String)element.getAttribute("page"));
        boolean preload = Boolean.parseBoolean(element.getAttribute("preload"));
        return new BinaryImageTask(labelId, priority, externalId, replaceWaitingTasks, image, page, preload);
    }

    private ResetTask parseResetTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element) {
        return new ResetTask(labelId, priority, externalId, replaceWaitingTasks);
    }

    private ResetImageTask parseResetImageTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element) {
        return new ResetImageTask(labelId, priority, externalId, replaceWaitingTasks);
    }

    private ResendTask parseResendTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element) throws IllegalArgumentException {
        UUID taskId = UUID.fromString(element.getAttribute("task-id"));
        return new ResendTask(labelId, priority, externalId, replaceWaitingTasks, taskId);
    }

    private FirmwareTask parseFirmwareTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element) {
        String firmwareFilename = element.getAttribute("file");
        return new FirmwareTask(labelId, priority, externalId, replaceWaitingTasks, firmwareFilename);
    }

    private SwitchPageTask parseSwitchPageTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element) throws NumberFormatException {
        Page page = Page.fromString((String)element.getAttribute("page"));
        return new SwitchPageTask(labelId, priority, externalId, replaceWaitingTasks, page);
    }

    private RefreshDisplayTask refreshDisplayTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element) {
        return new RefreshDisplayTask(labelId, priority, externalId, replaceWaitingTasks);
    }

    private ForceUpdateTask forceUpdateTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element) {
        return new ForceUpdateTask(labelId, priority, externalId, replaceWaitingTasks);
    }

    private PingTask pingTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element) {
        return new PingTask(labelId, priority, externalId, replaceWaitingTasks);
    }

    private UnlockLabelTask unlockLabelTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, Element element) {
        Puk puk = Puk.fromBase64((String)element.getAttribute("puk"));
        return new UnlockLabelTask(labelId, puk, priority, externalId, replaceWaitingTasks);
    }
}

