/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.tag.LabelTagsUpdate;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TagsUpdateXMLSerializer
implements XMLSerializer<LabelTagsUpdate> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(Collection<LabelTagsUpdate> tagsUpdates) throws SerializeException {
        Document document = this.xmlToolkit.newDocument();
        Element list = document.createElement("tags-updates");
        for (LabelTagsUpdate tagsUpdate : tagsUpdates) {
            list.appendChild(this.tagsUpdateToXml(document, tagsUpdate));
        }
        document.appendChild(list);
        return document;
    }

    private Element tagsUpdateToXml(Document document, LabelTagsUpdate tagsUpdate) {
        Element element = document.createElement("tags-update");
        element.setAttribute("label", tagsUpdate.getLabelId().getLabelIdString());
        element.setAttribute("operation", tagsUpdate.getOperation().toString().toLowerCase());
        for (String tag : tagsUpdate.getTags()) {
            Element tagElement = document.createElement("tag");
            tagElement.setAttribute("name", tag);
            element.appendChild(tagElement);
        }
        return element;
    }

    public Collection<LabelTagsUpdate> parseXML(InputStream xmlInputStream) throws SerializeException {
        ArrayList<LabelTagsUpdate> tasks = new ArrayList<LabelTagsUpdate>();
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(xmlInputStream);
        NodeList nodes = root.getElementsByTagName("tags-update");
        for (int index = 0; index < nodes.getLength(); ++index) {
            Element element = (Element)nodes.item(index);
            LabelTagsUpdate tagsUpdate = this.parseTagsUpdate(element);
            tasks.add(tagsUpdate);
        }
        return tasks;
    }

    private LabelTagsUpdate parseTagsUpdate(Element element) throws SerializeException {
        LabelId labelId = LabelId.fromString(element.getAttribute("label"));
        LabelTagsUpdate.Operation operation = element.hasAttribute("operation") ? LabelTagsUpdate.Operation.valueOf(element.getAttribute("operation").toUpperCase()) : LabelTagsUpdate.Operation.ADD;
        NodeList tagNodes = element.getElementsByTagName("tag");
        HashSet<String> tags = new HashSet<String>();
        for (int index = 0; index < tagNodes.getLength(); ++index) {
            Element valueElement = (Element)tagNodes.item(index);
            String tag = valueElement.getAttribute("name");
            tags.add(tag);
        }
        return new LabelTagsUpdate(labelId, tags, operation);
    }
}

