/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.type.ArticleNumber;
import at.mrdevelopment.esl.type.Matching;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MatchingXMLSerializer
implements XMLSerializer<Matching> {
    private final XMLToolkit xmlToolkit = new XMLToolkit("matching.xsd");

    public Document toXML(Collection<Matching> matchings) {
        Document document = this.xmlToolkit.newDocument();
        Element element = document.createElement("matchings");
        for (Matching matching : matchings) {
            Element matchingElement = document.createElement("matching");
            matchingElement.setAttribute("label", matching.getLabelId().getLabelIdString());
            if (matching.getArticleNumber() != null) {
                matchingElement.setAttribute("article", matching.getArticleNumber().toString());
            }
            if (matching.getTemplate() != null) {
                matchingElement.setAttribute("template", matching.getTemplate());
            }
            element.appendChild(matchingElement);
        }
        document.appendChild(element);
        return document;
    }

    public Collection<Matching> parseXML(InputStream inputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
        NodeList matchingNodes = root.getElementsByTagName("matching");
        ArrayList<Matching> matchings = new ArrayList<Matching>(matchingNodes.getLength());
        for (int index = 0; index < matchingNodes.getLength(); ++index) {
            Element matchingElement = (Element)matchingNodes.item(index);
            LabelId labelId = LabelId.fromString(matchingElement.getAttribute("label"));
            ArticleNumber articleNumber = matchingElement.hasAttribute("article") ? ArticleNumber.fromString((String)matchingElement.getAttribute("article")) : null;
            String template = matchingElement.hasAttribute("template") ? matchingElement.getAttribute("template") : null;
            Matching matching = new Matching(labelId, articleNumber, template);
            matchings.add(matching);
        }
        return matchings;
    }
}

