/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.update;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.Status;
import at.mrdevelopment.esl.persistence.record.LabelIdRecord;
import at.mrdevelopment.esl.persistence.record.TaskRecord;
import at.mrdevelopment.esl.persistence.record.TransactionRecord;
import at.mrdevelopment.esl.persistence.record.UpdateImage;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.tasks.ErrorTask;
import at.mrdevelopment.esl.tasks.ExecutableTask;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.image.BufferedImage;
import java.util.UUID;
import org.joda.time.DateTime;

public class Update
implements LabelIdRecord {
    private final UpdateStatus updateStatus;

    public static Update createWaiting(TransactionRecord transaction, ExecutableTask task, UUID taskId, int retries) throws SerializeException {
        TaskRecord taskRecord = new TaskRecord(transaction, task, retries);
        UpdateStatus updateStatus = new UpdateStatus(taskRecord, taskId, Status.WAITING, null, retries);
        return new Update(updateStatus);
    }

    public static Update createRetry(TaskRecord taskRecord, UUID taskId, int retriesLeft) {
        UpdateStatus updateStatus = new UpdateStatus(taskRecord, taskId, Status.WAITING, null, Math.max(0, retriesLeft));
        return new Update(updateStatus);
    }

    public static Update createError(TransactionRecord transaction, ErrorTask task, UUID taskId, UpdateError updateError) throws SerializeException {
        TaskRecord taskRecord = new TaskRecord(transaction, task);
        UpdateStatus updateStatus = new UpdateStatus(taskRecord, taskId, Status.ERROR, updateError, 0);
        return new Update(updateStatus);
    }

    public Update() {
        this.updateStatus = new UpdateStatus();
    }

    public Update(UpdateStatus updateStatus) {
        this.updateStatus = updateStatus;
    }

    @Override
    public LabelId getLabelId() {
        return this.updateStatus.getTaskRecord().getLabelId();
    }

    @Override
    public String getLabelIdString() {
        return this.updateStatus.getTaskRecord().getLabelIdString();
    }

    public UUID getTaskId() {
        return this.updateStatus.getTaskId();
    }

    public Status getStatus() {
        return this.updateStatus.getStatus();
    }

    public void setRemoved() {
        this.updateStatus.setStatus(Status.REMOVED);
        this.updateStatus.setRetriesLeft(0);
    }

    public void setDelayed() {
        this.updateStatus.setStatus(Status.DELAYED);
    }

    public void setError(UpdateError updateError) {
        this.updateStatus.setStatus(Status.ERROR);
        this.updateStatus.setUpdateError(updateError);
        this.updateStatus.setRetriesLeft(0);
    }

    public boolean isAssigned() {
        return this.updateStatus.getAccessPointId() != null;
    }

    public boolean isWaiting() {
        return this.getStatus().isWaiting();
    }

    public boolean isDelayed() {
        return this.getStatus().isDelayed();
    }

    public boolean isAbortRequested() {
        return this.getStatus().isAbortRequested();
    }

    public boolean isSuccessful() {
        return this.getStatus().isSuccessful();
    }

    public boolean isUnsuccessful() {
        return this.getStatus().isUnsuccessful();
    }

    public boolean isFinished() {
        return this.getStatus().isFinished();
    }

    public int getAccessPointId() {
        return this.updateStatus.getAccessPointId() != null ? this.updateStatus.getAccessPointId() : -1;
    }

    public int getRetriesLeft() {
        return this.updateStatus.getRetriesLeft();
    }

    public UpdateImage getUpdateImage() {
        return this.updateStatus.getTaskRecord().getUpdateImage();
    }

    public UpdateStatus getUpdateStatus() {
        return this.updateStatus;
    }

    public TaskRecord getTaskRecord() {
        return this.updateStatus.getTaskRecord();
    }

    public TaskType getTaskType() {
        return this.updateStatus.getTaskRecord().getTaskType();
    }

    public boolean isLabelMaintenance() {
        return this.updateStatus.getTaskRecord().getTaskType().isLabelMaintenance();
    }

    public boolean isImageTask() {
        return this.updateStatus.getTaskRecord().getTaskType().isImage();
    }

    public TaskPriority getPriority() {
        return this.updateStatus.getTaskRecord().getPriority();
    }

    public long getExternalId() {
        return this.hasExternalId() ? this.updateStatus.getTaskRecord().getExternalId() : 0L;
    }

    public Page getPage() {
        return Page.fromInteger((Integer)this.updateStatus.getTaskRecord().getPage());
    }

    public boolean isPreload() {
        return this.updateStatus.getTaskRecord().getTaskType() == TaskType.PRELOAD_IMAGE;
    }

    public boolean hasExternalId() {
        return this.updateStatus.getTaskRecord().hasExternalId();
    }

    public DateTime getUpdatedAt() {
        return this.updateStatus.getUpdatedAt();
    }

    public int getErrorCode() {
        return this.updateStatus.getErrorCode() != null ? this.updateStatus.getErrorCode() : 0;
    }

    public UpdateError getUpdateError() {
        return this.updateStatus.getUpdateError();
    }

    public PowerStatus getPowerStatus() {
        return this.updateStatus.getPowerStatus();
    }

    public boolean isPowerGood() {
        return this.updateStatus.getPowerStatus() != null ? this.updateStatus.getPowerStatus().isGood() : false;
    }

    public String getData() {
        return this.updateStatus.getTaskRecord().getData();
    }

    public BufferedImage getImage() throws SerializeException {
        return this.hasImage() ? this.updateStatus.getTaskRecord().getUpdateImage().getBufferedImage() : null;
    }

    public boolean hasUpdateStatus() {
        return this.updateStatus != null;
    }

    public boolean hasData() {
        return this.updateStatus.getTaskRecord().hasData();
    }

    public boolean hasImage() {
        return this.updateStatus.getTaskRecord().getUpdateImage() != null;
    }

    public boolean isLicenceRequired() {
        return this.updateStatus.getTaskRecord().getTaskType().isLicenceRequired();
    }
}

