/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type;

import at.mrdevelopment.esl.admin.LogLevel;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.SecurityStatus;
import at.mrdevelopment.esl.core.Status;
import at.mrdevelopment.esl.core.SyncQuality;
import at.mrdevelopment.esl.core.UpdateTaskStatus;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.persistence.record.CommitState;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.type.ArticleNumber;
import at.mrdevelopment.esl.type.BasicType;
import at.mrdevelopment.esl.type.EANCode;
import at.mrdevelopment.esl.type.Gtin;
import at.mrdevelopment.esl.type.LabelErrors;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.toolkit.Money;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.text.ParseException;
import java.util.UUID;
import org.joda.time.DateTime;

public class TypeFactory {
    static ESLLogger logger = ESLLogger.getLogger(TypeFactory.class);

    private TypeFactory() {
    }

    public static <S> S valueOf(Class<S> type, String valueString) throws SerializeException {
        if (type == null || valueString == null) {
            throw new NullPointerException();
        }
        try {
            if (valueString.isEmpty()) {
                return null;
            }
            if (type == Integer.class) {
                return type.cast(Integer.parseInt(valueString));
            }
            if (type == Long.class) {
                return type.cast(Long.parseLong(valueString));
            }
            if (type == Boolean.class) {
                return type.cast(Boolean.valueOf(valueString));
            }
            if (type == String.class) {
                return type.cast(valueString);
            }
            if (type == DateTime.class) {
                return type.cast(DateTime.parse((String)valueString));
            }
            if (type == UUID.class) {
                return type.cast(UUID.fromString(valueString));
            }
            if (type == LabelId.class) {
                return type.cast(LabelId.fromString(valueString));
            }
            if (type == LabelType.class) {
                return type.cast(LabelType.fromString((String)valueString));
            }
            if (type == Status.class) {
                return type.cast(Status.valueOf((String)valueString.toUpperCase()));
            }
            if (type == UpdateTaskStatus.class) {
                return type.cast(UpdateTaskStatus.valueOf((String)valueString.toUpperCase()));
            }
            if (type == UpdateError.class) {
                return type.cast(UpdateError.valueOf((int)Integer.parseInt(valueString)));
            }
            if (type == CommitState.class) {
                return type.cast(CommitState.valueOf((String)valueString.toUpperCase()));
            }
            if (type == ConnectionStatus.class) {
                return type.cast(ConnectionStatus.valueOf((String)valueString.toUpperCase()));
            }
            if (type == SecurityStatus.class) {
                return type.cast(SecurityStatus.valueOf((String)valueString.toUpperCase()));
            }
            if (type == PowerStatus.class) {
                return type.cast(PowerStatus.valueOf((String)valueString.toUpperCase()));
            }
            if (type == Role.class) {
                return type.cast(Role.valueOf((String)valueString.toUpperCase()));
            }
            if (type == BasicType.class) {
                return type.cast(BasicType.valueOf((String)valueString.toUpperCase()));
            }
            if (type == WirelessChannel.class) {
                return type.cast(WirelessChannel.fromString((String)valueString));
            }
            if (type == TaskType.class) {
                return type.cast(TaskType.valueOf((String)valueString.toUpperCase()));
            }
            if (type == TaskPriority.class) {
                return type.cast(TaskPriority.valueOf((String)valueString.toUpperCase()));
            }
            if (type == SyncQuality.class) {
                return type.cast(SyncQuality.valueOf((String)valueString));
            }
            if (type == LabelErrors.class) {
                return type.cast(LabelErrors.valueOf((String)valueString));
            }
            if (type == Version.class) {
                return type.cast(Version.fromString((String)valueString));
            }
            if (type == Page.class) {
                return type.cast(Page.fromString((String)valueString));
            }
            if (type == LogLevel.class) {
                return type.cast(LogLevel.valueOf((String)valueString.toUpperCase()));
            }
            if (type == ArticleNumber.class) {
                return type.cast(ArticleNumber.fromString((String)valueString));
            }
            if (type == Gtin.class) {
                return type.cast(Gtin.fromString((String)valueString));
            }
            return null;
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled((Throwable)exc);
            throw new SerializeException("%s could not be parsed to an instance of %s", new Object[]{valueString, type.getSimpleName()});
        }
    }

    public static Object valueOf(Class<?> type, Object value) throws NumberFormatException, ParseException {
        if (value == null) {
            return null;
        }
        if (type == LabelId.class) {
            return new LabelId((Long)value);
        }
        if (type == EANCode.class) {
            return new EANCode((String)value);
        }
        if (type == Money.class) {
            return new Money((String)value);
        }
        return value;
    }

    public static String toString(Object value) {
        if (value == null) {
            return new String();
        }
        if (value instanceof DateTime) {
            return ((DateTime)value).toLocalDateTime().toString();
        }
        if (value instanceof SyncQuality) {
            return Integer.toString(((SyncQuality)value).getSyncQualityValue());
        }
        if (value instanceof Page) {
            return Integer.toString(((Page)value).getPageIndex());
        }
        return value.toString();
    }
}

