/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type;

import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.toolkit.collection.PartitionedListIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TaskOrder {
    private final String title;
    private final long externalId;
    private final List<Task> tasks;

    public TaskOrder(Task task) {
        this(Collections.singletonList(task));
    }

    public TaskOrder(String title, long externalId, Task task) {
        this(title, externalId, Collections.singletonList(task));
    }

    public TaskOrder(List<Task> tasks) {
        this(null, 0L, tasks);
    }

    public TaskOrder(String title, long externalId, List<Task> tasks) {
        this.title = title;
        this.externalId = externalId;
        this.tasks = tasks;
    }

    public String getTitle() {
        return this.title;
    }

    public long getExternalId() {
        return this.externalId;
    }

    public List<Task> getTasks() {
        return Collections.unmodifiableList(this.tasks);
    }

    public int getSize() {
        return this.tasks.size();
    }

    public Iterable<TaskOrder> getPartitions(int partitionSize) {
        Iterable listPartitions = PartitionedListIterator.createPartitions(this.tasks, (int)partitionSize);
        final Iterator partitionsIterator = listPartitions.iterator();
        return new Iterable<TaskOrder>(){

            @Override
            public Iterator<TaskOrder> iterator() {
                return new Iterator<TaskOrder>(){

                    @Override
                    public boolean hasNext() {
                        return partitionsIterator.hasNext();
                    }

                    @Override
                    public TaskOrder next() {
                        return new TaskOrder(TaskOrder.this.title, TaskOrder.this.externalId, (List)partitionsIterator.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

