/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.table;

import at.mrdevelopment.esl.template.table.TableDataMetric;
import at.mrdevelopment.esl.template.table.TableElementPosition;
import at.mrdevelopment.esl.template.table.TableMetrics;
import java.util.ArrayList;
import java.util.List;

public class TableRowMetric {
    private final int width;
    private int height;
    private List<TableDataMetric> tableDataMetrics;
    private final TableElementPosition position;
    private int maxTopBorder = 0;
    private int maxBottomBorder = 0;
    private int effectiveHeight;
    private int borderOffset;

    public TableRowMetric(TableElementPosition position, int width, int height) {
        this.position = position;
        this.width = width;
        this.height = height;
        this.tableDataMetrics = new ArrayList<TableDataMetric>();
    }

    public void addTableDataMetric(TableDataMetric tableDataMetric) {
        this.tableDataMetrics.add(tableDataMetric);
        this.maxTopBorder = Math.max(tableDataMetric.getTableDataBorder().getBorderTop(), this.maxTopBorder);
        this.maxBottomBorder = Math.max(tableDataMetric.getTableDataBorder().getBorderBottom(), this.maxBottomBorder);
    }

    public void calculateMetrics(TableMetrics tableMetrics) {
        int totalBorderWidth = 0;
        for (int columnIndex = 0; columnIndex < this.tableDataMetrics.size(); ++columnIndex) {
            TableDataMetric tableDataMetric = this.tableDataMetrics.get(columnIndex);
            totalBorderWidth += tableDataMetric.getTableDataBorder().getBorderRight();
            if (columnIndex != 0) continue;
            totalBorderWidth += tableDataMetric.getTableDataBorder().getBorderLeft();
        }
        float borderWidthValue = (float)totalBorderWidth / (float)this.tableDataMetrics.size();
        int columnXPos = 0;
        for (int columnIndex = 0; columnIndex < this.tableDataMetrics.size(); ++columnIndex) {
            TableDataMetric tableDataMetric = this.tableDataMetrics.get(columnIndex);
            tableDataMetric.setXPos(columnXPos += tableDataMetric.getTableDataBorder().getBorderLeft());
            if (tableDataMetric.getPosition().equals((Object)TableElementPosition.LAST)) {
                tableDataMetric.setBorderOffset(tableDataMetric.getEffectiveWidth() + tableDataMetric.getXPos() + tableDataMetric.getTableDataBorder().getBorderLeft() - tableMetrics.getTableWidth());
            } else {
                tableDataMetric.setBorderOffset((int)borderWidthValue);
            }
            columnXPos += tableDataMetric.getEffectiveWidth();
        }
    }

    public List<TableDataMetric> getTableDataMetrics() {
        return this.tableDataMetrics;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public TableElementPosition getPosition() {
        return this.position;
    }

    public int getPosX() {
        return this.tableDataMetrics.get(0).getTableDataBorder().getBorderLeft();
    }

    public int getMaxTopBorder() {
        return this.maxTopBorder;
    }

    public int getMaxBottomBorder() {
        return this.maxBottomBorder;
    }

    public void setEffectiveHeight(int effectiveHeight) {
        this.effectiveHeight = effectiveHeight;
    }

    public int getEffectiveHeight() {
        return this.effectiveHeight;
    }

    public void setBorderOffset(int borderOffset) {
        this.borderOffset = borderOffset;
    }

    public int getBorderOffset() {
        return this.borderOffset;
    }

    public int getMaxTopBorderOffset() {
        return this.maxTopBorder / 2;
    }
}

