/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.table;

import at.mrdevelopment.esl.template.RenderingElement;
import at.mrdevelopment.esl.template.RenderingResult;
import at.mrdevelopment.esl.template.table.TableDataField;
import at.mrdevelopment.esl.template.table.TableDataMetric;
import at.mrdevelopment.esl.template.table.TableElementPosition;
import at.mrdevelopment.esl.template.table.TableMetrics;
import at.mrdevelopment.esl.template.table.TableRowMetric;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.StringElement;
import at.mrdevelopment.toolkit.TableRenderingExceptionElement;
import at.mrdevelopment.toolkit.TableRenderingStringElement;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.Element;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.image.HorizontalAlignment;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.image.VerticalAlignment;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.options.Size;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@TemplateElementType(type=TemplateNode.TABLE_ROW)
public class TableRowField
extends Element
implements RenderingElement {
    private List<TableDataField> tableDataFields = new ArrayList<TableDataField>();
    private int border;
    private final Color borderColor;
    private final Color backgroundColor;
    private Size height;
    private TableMetrics tableMetrics;

    public TableRowField(Map<String, Option<?>> options, int border, Color borderColor, Color backgroundColor) throws OptionException {
        super(options);
        this.height = options.containsKey(Attribute.TABLE_HEIGHT.getKey()) && options.get(Attribute.TABLE_HEIGHT.getKey()).get() != null ? (Size)options.get(Attribute.TABLE_HEIGHT.getKey()).get() : new Size("-1");
        this.border = border;
        this.borderColor = borderColor;
        this.backgroundColor = backgroundColor;
    }

    public Collection<Attribute> getRequiredAttributes() {
        return Collections.emptyList();
    }

    public void addTableData(TableDataField tableDataField) {
        this.tableDataFields.add(tableDataField);
    }

    public List<TableDataField> getTableDataFields() {
        return this.tableDataFields;
    }

    @Override
    public RenderingResult render(int maxWidth, int maxHeight, boolean verbose) {
        int tableDataHeight = 0;
        ExecutionStatus status = new ExecutionStatus();
        boolean successful = true;
        if (maxWidth > 0 && maxHeight > 0) {
            int lastLineOffset;
            BufferedImage image = ImageUtils.createImage((int)maxWidth, (int)maxHeight, (int)2);
            ImageUtils.fillRect((BufferedImage)image, (int)0, (int)0, (int)maxWidth, (int)maxHeight, (Color)this.backgroundColor);
            int height = 0;
            ArrayList<RenderingResult> renderingResults = new ArrayList<RenderingResult>();
            TableRowMetric tableRowMetric = this.tableMetrics.getTableRowMetric(this);
            for (int index = 0; index < this.tableDataFields.size(); ++index) {
                TableDataField tableDataField = this.tableDataFields.get(index);
                TableDataMetric tableDataMetric = tableRowMetric.getTableDataMetrics().get(index);
                tableDataHeight = maxHeight - tableDataMetric.getTableDataBorder().getBorderTop();
                if (tableDataMetric.getPosition().isLast()) {
                    tableDataHeight -= tableDataMetric.getTableDataBorder().getBorderBottom();
                }
                RenderingResult renderingResult = tableDataField.render(tableDataMetric.getEffectiveWidth() - 2 * tableDataField.getCellpadding(), tableDataHeight - 2 * tableDataField.getCellpadding(), verbose);
                renderingResults.add(renderingResult);
                successful = !renderingResult.isSuccessful() ? false : successful;
                this.convertToTableExecutionStatus(status, renderingResult, this.tableMetrics.getRowIndex(this) + 1, index + 1);
                height = Math.max(renderingResult.getBounds().height + 2 * tableDataField.getCellpadding() + tableRowMetric.getMaxTopBorder(), height);
            }
            int n = lastLineOffset = tableRowMetric.getPosition().equals((Object)TableElementPosition.LAST) ? tableRowMetric.getMaxBottomBorder() : 0;
            if (tableRowMetric.getHeight() > 0) {
                height = tableRowMetric.getHeight();
            }
            Rectangle bounds = new Rectangle(0, 0, maxWidth, height += lastLineOffset);
            if (image != null && bounds != null && !bounds.isEmpty()) {
                try {
                    image = ImageUtils.clipToUsedSize((BufferedImage)image, (Rectangle)bounds, (int)maxWidth, (int)maxHeight);
                }
                catch (IllegalArgumentException exc) {
                    status.addElement((ExecutionStatusElement)new TableRenderingExceptionElement((Exception)exc, this.tableMetrics.getRowIndex(this) + 1, 0));
                    successful = false;
                }
            } else {
                status.addElement((ExecutionStatusElement)new TableRenderingStringElement("Table cannot be empty.", this.tableMetrics.getRowIndex(this) + 1, 0));
                successful = false;
            }
            for (int index = 0; index < renderingResults.size(); ++index) {
                int effectiveHeight = height - lastLineOffset - tableRowMetric.getMaxTopBorder();
                TableDataMetric tableDataMetric = tableRowMetric.getTableDataMetrics().get(index);
                int xPos = tableDataMetric.getXPos();
                int topBorderYPos = tableRowMetric.getPosition().isFirst() ? 0 : (tableRowMetric.getMaxTopBorder() > tableDataMetric.getTableDataBorder().getBorderTop() ? 0 : tableRowMetric.getMaxTopBorder() - tableDataMetric.getTableDataBorder().getBorderTop());
                ImageUtils.overlay((BufferedImage)image, null, (BufferedImage)((RenderingResult)renderingResults.get(index)).getImage(), (Rectangle)((RenderingResult)renderingResults.get(index)).getBounds(), (int)(xPos + this.tableDataFields.get(index).getCellpadding()), (int)(tableDataMetric.getTableDataBorder().getBorderTop() + this.tableDataFields.get(index).getCellpadding()), (int)(tableDataMetric.getEffectiveWidth() - 2 * this.tableDataFields.get(index).getCellpadding()), (int)(effectiveHeight - 2 * this.tableDataFields.get(index).getCellpadding()), (int)0, (HorizontalAlignment)HorizontalAlignment.LEFT, (VerticalAlignment)this.tableDataFields.get(index).getVerticalAlignment());
                Rectangle leftBorder = new Rectangle(xPos - tableDataMetric.getTableDataBorder().getBorderLeft(), 0, tableDataMetric.getTableDataBorder().getBorderLeft(), height);
                ImageUtils.drawContinuousBorderLine((BufferedImage)image, (int)leftBorder.x, (int)0, (int)leftBorder.x, (int)height, (Color)this.getBorderColor(), (int)tableDataMetric.getTableDataBorder().getBorderLeft());
                ImageUtils.drawContinuousBorderLine((BufferedImage)image, (int)xPos, (int)topBorderYPos, (int)(xPos + tableDataMetric.getEffectiveWidth()), (int)topBorderYPos, (Color)this.getBorderColor(), (int)tableDataMetric.getTableDataBorder().getBorderTop());
                if (tableDataMetric.getPosition().isLast()) {
                    ImageUtils.drawContinuousBorderLine((BufferedImage)image, (int)(xPos + tableDataMetric.getEffectiveWidth()), (int)0, (int)(xPos + tableDataMetric.getEffectiveWidth()), (int)height, (Color)this.getBorderColor(), (int)tableDataMetric.getTableDataBorder().getBorderRight());
                }
                if (tableRowMetric.getPosition().isLast()) {
                    int bottomYPos = effectiveHeight + tableRowMetric.getMaxTopBorder() + tableRowMetric.getMaxBottomBorder() - tableDataMetric.getTableDataBorder().getBorderBottom();
                    ImageUtils.drawContinuousBorderLine((BufferedImage)image, (int)xPos, (int)bottomYPos, (int)(xPos + tableDataMetric.getEffectiveWidth()), (int)bottomYPos, (Color)this.getBorderColor(), (int)tableDataMetric.getTableDataBorder().getBorderBottom());
                }
                xPos += tableDataMetric.getTableDataBorder().getBorderLeft() + tableRowMetric.getTableDataMetrics().get(index).getEffectiveWidth();
            }
            return new RenderingResult(image, status, bounds, successful);
        }
        status.addElement((ExecutionStatusElement)new TableRenderingStringElement(String.format("No space left for table row (width: %d, height: %d)", maxWidth, maxHeight), this.tableMetrics.getRowIndex(this) + 1));
        return new RenderingResult(null, status, null, false);
    }

    private void convertToTableExecutionStatus(ExecutionStatus status, RenderingResult renderingResult, int rowNumber, int columnNumber) {
        for (ExecutionStatusElement element : renderingResult.getStatus().getElements()) {
            if (element instanceof StringElement) {
                status.addElement((ExecutionStatusElement)new TableRenderingStringElement((String)element.getElement(), rowNumber, columnNumber));
                continue;
            }
            if (element instanceof ExceptionElement) {
                status.addElement((ExecutionStatusElement)new TableRenderingExceptionElement((Exception)element.getElement(), rowNumber, columnNumber));
                continue;
            }
            status.addElement(element);
        }
    }

    public Size getHeight() {
        return this.height;
    }

    public void setTableMetrics(TableMetrics tableMetrics) {
        this.tableMetrics = tableMetrics;
    }

    public int getBorder() {
        return this.border;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Map<String, Option<?>> getOptions() {
        return super.getOptions();
    }

    public void setBorder(int currentBorder) {
        this.border = currentBorder;
    }
}

