/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.table;

import at.mrdevelopment.Pair;
import at.mrdevelopment.esl.template.TextFieldContainer;
import at.mrdevelopment.esl.template.table.TableBorder;
import at.mrdevelopment.esl.template.table.TableDataField;
import at.mrdevelopment.esl.template.table.TableDataMetric;
import at.mrdevelopment.esl.template.table.TableElementPosition;
import at.mrdevelopment.esl.template.table.TableField;
import at.mrdevelopment.esl.template.table.TableRowField;
import at.mrdevelopment.esl.template.table.TableRowMetric;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.TableRenderingStringElement;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.options.Option;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableMetrics {
    private final TableField tableField;
    private int tableWidth;
    private int tableHeight;
    private List<Integer> tableDataWidths = new ArrayList<Integer>();
    private List<Integer> tableRowHeights = new ArrayList<Integer>();
    private int remainingHeight;
    private final ExecutionStatus status;
    private List<TableRowMetric> tableRowMetrics = new ArrayList<TableRowMetric>();

    public TableMetrics(TableField tableField, Map<String, Option<?>> options, int maxWidth, int maxHeight) {
        this.tableField = tableField;
        this.status = new ExecutionStatus();
        this.checkEmptyRows(maxWidth, maxHeight, options);
        this.calculateTableMetrics(maxHeight);
    }

    private void checkEmptyRows(int maxWidth, int maxHeight, Map<String, Option<?>> options) {
        for (TableRowField tableRowField : this.tableField.getTableRowFields()) {
            if (tableRowField.getTableDataFields().size() != 0) continue;
            this.handleEmptyRow(tableRowField, maxWidth, maxHeight, options);
        }
    }

    private void handleEmptyRow(TableRowField tableRowField, int maxWidth, int maxHeight, Map<String, Option<?>> options) {
        if (tableRowField.getTableDataFields().size() == 0) {
            try {
                tableRowField.getTableDataFields().add(new TableDataField(this.createTableDataOptions(tableRowField.getOptions()), new TextFieldContainer(options), tableRowField.getBorder(), tableRowField.getBorderColor(), tableRowField.getBackgroundColor()));
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    private Map<String, Option<?>> createTableDataOptions(Map<String, Option<?>> tableRowOptions) throws SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        HashMap tableDataOptions = new HashMap();
        tableDataOptions.putAll(tableRowOptions);
        tableDataOptions.remove(Attribute.TABLE_HEIGHT.getKey());
        tableDataOptions.put(Attribute.TABLE_WIDTH.getKey(), Attribute.TABLE_WIDTH.createOption());
        return tableDataOptions;
    }

    private void calculateTableMetrics(int maxHeight) {
        int rowIndex;
        this.tableWidth = this.tableField.getWidth();
        this.tableHeight = this.tableField.getHeight() <= 0 ? maxHeight : this.tableField.getHeight();
        int totalRowHeight = 0;
        for (rowIndex = 0; rowIndex < this.tableField.getTableRowFields().size(); ++rowIndex) {
            TableRowField tableRow = this.tableField.getTableRowFields().get(rowIndex);
            int rowHeight = this.calculateRowHeight(tableRow);
            this.tableRowHeights.add(rowHeight);
            totalRowHeight += rowHeight < 0 ? 0 : rowHeight;
            for (int dataIndex = 0; dataIndex < tableRow.getTableDataFields().size(); ++dataIndex) {
                int dataWidth = this.calculateTableDataWidth(tableRow.getTableDataFields().get(dataIndex), rowIndex, dataIndex);
                if (dataIndex >= this.tableDataWidths.size()) {
                    this.tableDataWidths.add(dataWidth);
                    continue;
                }
                if (dataWidth <= this.tableDataWidths.get(dataIndex)) continue;
                this.tableDataWidths.set(dataIndex, dataWidth);
            }
        }
        this.checkColumnWidths();
        for (rowIndex = 0; rowIndex < this.tableField.getTableRowFields().size(); ++rowIndex) {
            TableRowField tableRowField = this.tableField.getTableRowFields().get(rowIndex);
            TableElementPosition position = TableElementPosition.getTableElementPosition(rowIndex, this.tableField.getTableRowFields());
            int rowHeight = this.getRowHeight(tableRowField);
            TableRowMetric tableRowMetric = new TableRowMetric(position, this.getEffectiveRowWidth(tableRowField), rowHeight);
            this.tableRowMetrics.add(tableRowMetric);
            int rowBorderTop = this.tableField.isHeaderRow() && rowIndex < 2 ? this.tableField.getHeaderBorder() : this.tableField.getTableBorder();
            int rowBorderBottom = this.tableField.isHeaderRow() && rowIndex == 0 ? this.tableField.getHeaderBorder() : this.tableField.getTableBorder();
            for (int dataIndex = 0; dataIndex < tableRowField.getTableDataFields().size(); ++dataIndex) {
                TableElementPosition dataPosition = TableElementPosition.getTableElementPosition(dataIndex, tableRowField.getTableDataFields());
                int width = this.getTableDataWidth(tableRowField, dataIndex);
                int borderLeft = this.tableField.getTableBorder();
                int borderRight = this.tableField.getTableBorder();
                int borderTop = rowBorderTop;
                int borderBottom = rowBorderBottom;
                if (this.tableField.isHeaderRow() && rowIndex == 0) {
                    borderLeft = this.tableField.getHeaderBorder();
                    borderRight = this.tableField.getHeaderBorder();
                }
                if (this.tableField.isHeaderColumn()) {
                    if (dataIndex == 0) {
                        borderLeft = this.tableField.getHeaderBorder();
                        borderRight = this.tableField.getHeaderBorder();
                        borderTop = this.tableField.getHeaderBorder();
                        borderBottom = this.tableField.getHeaderBorder();
                    } else if (dataIndex == 1) {
                        borderLeft = this.tableField.getHeaderBorder();
                    }
                }
                TableBorder tableDataBorder = new TableBorder(borderLeft, borderRight, borderTop, borderBottom);
                TableDataMetric tableDataMetric = new TableDataMetric(tableDataBorder, dataPosition, width, rowHeight);
                tableRowMetric.addTableDataMetric(tableDataMetric);
            }
        }
        for (TableRowMetric tableRowMetric : this.tableRowMetrics) {
            tableRowMetric.calculateMetrics(this);
        }
        int totalBorderHeight = 0;
        for (int index = 0; index < this.tableRowMetrics.size(); ++index) {
            totalBorderHeight += this.tableRowMetrics.get(index).getMaxBottomBorder();
            if (index != 0) continue;
            totalBorderHeight += this.tableRowMetrics.get(index).getMaxTopBorder();
        }
        float borderHeightValue = (float)totalBorderHeight / (float)this.tableRowMetrics.size();
        for (int index = 0; index < this.tableRowMetrics.size(); ++index) {
            TableRowMetric tableRowMetric = this.tableRowMetrics.get(index);
            if (tableRowMetric.getPosition().isLast()) {
                tableRowMetric.setBorderOffset((int)borderHeightValue + (int)Math.ceil(borderHeightValue % 1.0f * (float)this.tableRowMetrics.size()));
                continue;
            }
            tableRowMetric.setBorderOffset((int)borderHeightValue);
        }
        this.remainingHeight = this.tableHeight - totalRowHeight;
    }

    private void checkColumnWidths() {
        int index;
        int totalWidth = 0;
        for (index = 0; index < this.tableDataWidths.size(); ++index) {
            if (this.tableDataWidths.get(index) <= 0) continue;
            totalWidth += this.tableDataWidths.get(index).intValue();
        }
        if (totalWidth > this.tableWidth) {
            this.status.addElement((ExecutionStatusElement)new TableRenderingStringElement(String.format("Total table column size (%d) exceeds table size (%d)", totalWidth, this.tableWidth), 0));
            for (index = this.tableDataWidths.size() - 1; index >= 0; --index) {
                if (this.tableDataWidths.get(index) <= 0) continue;
                int currentWidth = this.tableDataWidths.get(index);
                this.tableDataWidths.set(index, -1);
                if ((totalWidth -= currentWidth) <= this.tableWidth) break;
            }
        }
    }

    private int calculateTableDataWidth(TableDataField tableData, int rowIndex, int dataIndex) {
        boolean outOfBounds = false;
        outOfBounds = tableData.getWidth().isOutOfBounds(this.tableWidth);
        if (outOfBounds || tableData.getWidth().isEmpty()) {
            if (outOfBounds) {
                this.status.addElement((ExecutionStatusElement)new TableRenderingStringElement(String.format("Table cell width (%d) exceeds table width (%d).", tableData.getWidth().getSize(this.tableWidth), this.tableWidth), rowIndex + 1, dataIndex + 1));
            }
            return -1;
        }
        return tableData.getWidth().getSize(this.tableWidth);
    }

    private int calculateRowHeight(TableRowField tableRow) {
        boolean outOfBounds = false;
        outOfBounds = tableRow.getHeight().isOutOfBounds(this.tableHeight);
        if (outOfBounds || tableRow.getHeight().isEmpty()) {
            if (outOfBounds) {
                this.status.addElement((ExecutionStatusElement)new TableRenderingStringElement(String.format("Table row height (%d) exceeds table height (%d).", tableRow.getHeight().getSize(this.tableHeight), this.tableHeight), this.tableField.getTableRowFields().indexOf(tableRow) + 1));
            }
            return 0;
        }
        return tableRow.getHeight().getSize(this.tableHeight);
    }

    public int getTableDataWidth(TableRowField tableRow, int dataIndex) {
        int rowWidth;
        if (this.tableDataWidths.get(dataIndex) > 0) {
            return this.tableDataWidths.get(dataIndex);
        }
        int rowIndex = this.tableField.getTableRowFields().indexOf(tableRow);
        int dynamicCount = 0;
        int remainingWidth = rowWidth = this.tableWidth;
        for (int index = 0; index < this.tableField.getTableRowFields().get(rowIndex).getTableDataFields().size(); ++index) {
            if (this.tableDataWidths.get(index) > 0) {
                remainingWidth -= this.tableDataWidths.get(index).intValue();
                continue;
            }
            ++dynamicCount;
        }
        return remainingWidth / dynamicCount;
    }

    public int getTableWidth() {
        return this.tableWidth;
    }

    public int getTableHeight() {
        return this.tableHeight;
    }

    public List<Integer> getTableRowHeights() {
        return this.tableRowHeights;
    }

    public int getRemainingHeight() {
        return this.remainingHeight;
    }

    public void setRemainingHeight(int remainingHeight) {
        this.remainingHeight = remainingHeight;
    }

    public ExecutionStatus getStatus() {
        return this.status;
    }

    public int getEffectiveRowWidth(TableRowField tableRowField) {
        int width = 0;
        for (int index = 0; index < tableRowField.getTableDataFields().size(); ++index) {
            width += this.getTableDataWidth(tableRowField, index);
        }
        return width;
    }

    public int getRowHeight(TableRowField tableRowField) {
        return this.tableRowHeights.get(this.tableField.getTableRowFields().indexOf(tableRowField));
    }

    public int getRowIndex(TableRowField tableRowField) {
        return this.tableField.getTableRowFields().indexOf(tableRowField);
    }

    public Pair<Integer, Integer> getTableDataIndex(TableDataField tableDataField) {
        for (int rowIndex = 0; rowIndex < this.tableField.getTableRowFields().size(); ++rowIndex) {
            TableRowField tableRowField = this.tableField.getTableRowFields().get(rowIndex);
            int columnIndex = tableRowField.getTableDataFields().indexOf(tableDataField);
            if (columnIndex < 0) continue;
            return new Pair((Object)rowIndex, (Object)columnIndex);
        }
        return new Pair((Object)-1, (Object)-1);
    }

    public List<TableRowMetric> getTableRowMetrics() {
        return this.tableRowMetrics;
    }

    public TableRowMetric getTableRowMetric(int rowIndex) {
        return this.tableRowMetrics.get(rowIndex);
    }

    public TableRowMetric getTableRowMetric(TableRowField tableRowField) {
        return this.getTableRowMetric(this.tableField.getTableRowFields().indexOf(tableRowField));
    }

    public int getTableRowYPos(int rowIndex) {
        int yPos = 0;
        for (int index = 0; index < rowIndex; ++index) {
            TableRowMetric tableRowMetric = this.tableRowMetrics.get(index);
            yPos += tableRowMetric.getEffectiveHeight();
        }
        return yPos;
    }

    public void setEffectiveTableRowHeight(int rowIndex, int height) {
        this.tableRowMetrics.get(rowIndex).setEffectiveHeight(height);
    }

    public boolean isHeaderColumn() {
        return this.tableField.isHeaderColumn();
    }

    public boolean isHeaderRow() {
        return this.tableField.isHeaderRow();
    }
}

