/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.css;

import com.steadystate.css.dom.CSSStyleRuleImpl;
import com.steadystate.css.parser.selectors.ConditionalSelectorImpl;
import com.steadystate.css.parser.selectors.DescendantSelectorImpl;
import org.w3c.css.sac.Selector;

public class CSSOptionRule {
    private final CSSStyleRuleImpl rule;
    private int priority;

    public CSSOptionRule(CSSStyleRuleImpl rule) {
        this.rule = rule;
        this.calculatePriority();
    }

    private void calculatePriority() {
        for (int index = 0; index < this.rule.getSelectors().getLength(); ++index) {
            Selector selector = this.rule.getSelectors().item(index);
            this.priority += this.getPriority(selector);
        }
    }

    private int getPriority(Selector selector) {
        switch (selector.getSelectorType()) {
            case 10: {
                DescendantSelectorImpl descendentSelector = (DescendantSelectorImpl)selector;
                return this.getPriority(descendentSelector.getAncestorSelector()) + 1;
            }
            case 4: {
                return 1;
            }
            case 0: {
                ConditionalSelectorImpl conditionalSelector = (ConditionalSelectorImpl)selector;
                switch (conditionalSelector.getCondition().getConditionType()) {
                    case 5: {
                        return 100;
                    }
                    case 9: {
                        return 10;
                    }
                }
                break;
            }
            case 11: {
                return 1;
            }
        }
        return 0;
    }

    public CSSStyleRuleImpl getRule() {
        return this.rule;
    }

    public int getRulePriority() {
        return this.priority;
    }
}

