/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template.css;

import at.mrdevelopment.esl.template.TemplateTree;
import at.mrdevelopment.esl.template.TemplateTreeNode;
import at.mrdevelopment.esl.template.css.CSSOptionParser;
import at.mrdevelopment.esl.template.css.CSSOptionRule;
import at.mrdevelopment.esl.template.css.CSSOptionRuleComparator;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.options.OptionException;
import com.steadystate.css.dom.CSSValueImpl;
import com.steadystate.css.parser.selectors.ChildSelectorImpl;
import com.steadystate.css.parser.selectors.ClassConditionImpl;
import com.steadystate.css.parser.selectors.ConditionalSelectorImpl;
import com.steadystate.css.parser.selectors.DescendantSelectorImpl;
import com.steadystate.css.parser.selectors.ElementSelectorImpl;
import com.steadystate.css.parser.selectors.IdConditionImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.Selector;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSInterpreter {
    static ESLLogger logger = ESLLogger.getLogger(CSSInterpreter.class);

    public void interpret(TemplateTree templateTree, String cssFilename) throws FileNotFoundException, IOException {
        CSSOptionParser parser = new CSSOptionParser();
        this.interpret(templateTree, parser.parse(cssFilename));
    }

    public void interpret(TemplateTree templateTree, List<CSSOptionRule> rules) {
        List<TemplateTreeNode> totalNodeList = templateTree.toList();
        Collections.sort(rules, new CSSOptionRuleComparator());
        for (CSSOptionRule rule : rules) {
            this.applyStyleRule(rule, new ArrayList<TemplateTreeNode>(totalNodeList));
        }
    }

    private void applyStyleRule(CSSOptionRule optionRule, Collection<TemplateTreeNode> nodeList) {
        HashSet<TemplateTreeNode> appliedList = new HashSet<TemplateTreeNode>();
        for (int index = 0; index < optionRule.getRule().getSelectors().getLength(); ++index) {
            Selector selector = optionRule.getRule().getSelectors().item(index);
            appliedList.addAll(this.applySelector(selector, nodeList, index));
        }
        CSSStyleDeclaration style = optionRule.getRule().getStyle();
        for (TemplateTreeNode node : appliedList) {
            for (int index = 0; index < style.getLength(); ++index) {
                String attributeKey = style.item(index);
                String attributeValue = this.getAttributeValue(style.getPropertyCSSValue(attributeKey));
                try {
                    if (!node.getOptions().containsKey(attributeKey) || node.getOptions().get(attributeKey).hasValueChanged()) continue;
                    node.getOptions().get(attributeKey).setValueFromString(attributeValue);
                    continue;
                }
                catch (OptionException exc) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.warn("Error setting option from CSS file.");
                    logger.logException((Throwable)exc);
                }
            }
        }
    }

    private String getAttributeValue(CSSValue cssValue) {
        CSSValueImpl cssValueImpl;
        String cssText = cssValue.getCssText();
        if (cssValue instanceof CSSValueImpl && (cssValueImpl = (CSSValueImpl)cssValue).getPrimitiveType() == 19) {
            cssText = cssValueImpl.getStringValue();
        }
        return StringEscapeUtils.unescapeHtml((String)cssText);
    }

    private Collection<TemplateTreeNode> applySelector(Selector selector, Collection<TemplateTreeNode> nodeList, int depth) {
        Collection<TemplateTreeNode> appliedList = new HashSet<TemplateTreeNode>(nodeList);
        if (selector != null) {
            switch (selector.getSelectorType()) {
                case 10: {
                    DescendantSelectorImpl descendentSelector = (DescendantSelectorImpl)selector;
                    appliedList = this.applySelector((Selector)descendentSelector.getSimpleSelector(), appliedList, depth);
                    appliedList = this.applySelector(descendentSelector.getAncestorSelector(), appliedList, depth + 1);
                    break;
                }
                case 4: {
                    ElementSelectorImpl elementSelector = (ElementSelectorImpl)selector;
                    appliedList = this.getNodesFromSelector(elementSelector, appliedList, depth);
                    break;
                }
                case 0: {
                    ConditionalSelectorImpl conditionalSelector = (ConditionalSelectorImpl)selector;
                    appliedList = this.getNodesFromSelector(conditionalSelector, appliedList, depth);
                    break;
                }
                case 11: {
                    ChildSelectorImpl childSelector = (ChildSelectorImpl)selector;
                    appliedList = this.getNodesFromSelector(childSelector, appliedList, depth);
                    appliedList = this.applySelector(childSelector.getAncestorSelector(), appliedList, depth + 1);
                }
            }
        }
        return appliedList;
    }

    private TemplateTreeNode getNode(TemplateTreeNode node, int depth) {
        TemplateTreeNode parentNode = node;
        if (depth > 0) {
            for (int depthIndex = 0; depthIndex < depth; ++depthIndex) {
                parentNode = parentNode != null ? parentNode.getParent() : null;
            }
        }
        return parentNode;
    }

    private Collection<TemplateTreeNode> getNodesFromSelector(ConditionalSelectorImpl conditionalSelector, Collection<TemplateTreeNode> appliedList, int depth) {
        Condition condition = conditionalSelector.getCondition();
        switch (condition.getConditionType()) {
            case 5: {
                IdConditionImpl idCondition = (IdConditionImpl)condition;
                String id = idCondition.getValue();
                ArrayList<TemplateTreeNode> nodeList = new ArrayList<TemplateTreeNode>();
                for (TemplateTreeNode node : appliedList) {
                    TemplateTreeNode parentNode = this.getNode(node, depth);
                    try {
                        if (parentNode == null || parentNode.getId() == null || !parentNode.getId().equals(id)) continue;
                        nodeList.add(node);
                    }
                    catch (OptionException exc) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.warn("Error getting id from template node (%s)", new Object[]{parentNode != null ? parentNode.getTemplateNode().getKey() : "unknown"});
                        logger.logException((Throwable)exc);
                    }
                }
                return nodeList;
            }
            case 9: {
                ClassConditionImpl classCondition = (ClassConditionImpl)condition;
                String className = classCondition.getValue();
                ArrayList<TemplateTreeNode> nodesToRemove = new ArrayList<TemplateTreeNode>();
                for (TemplateTreeNode node : appliedList) {
                    TemplateTreeNode parentNode = this.getNode(node, depth);
                    try {
                        if (parentNode != null && parentNode.getCSSClass() != null && parentNode.getCSSClass().equals(className)) continue;
                        nodesToRemove.add(node);
                    }
                    catch (OptionException exc) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.warn("Error getting class from template node (%s)", new Object[]{parentNode != null ? parentNode.getTemplateNode().getKey() : "unknown"});
                        logger.logException((Throwable)exc);
                    }
                }
                appliedList.removeAll(nodesToRemove);
            }
        }
        return appliedList;
    }

    private Collection<TemplateTreeNode> getNodesFromSelector(ElementSelectorImpl elementSelector, Collection<TemplateTreeNode> appliedList, int depth) {
        String nodeName = elementSelector.getLocalName();
        ArrayList<TemplateTreeNode> nodesToRemove = new ArrayList<TemplateTreeNode>();
        for (TemplateTreeNode node : appliedList) {
            TemplateTreeNode parentNode = this.getNode(node, depth);
            if (parentNode != null && parentNode.getTemplateNode().getKey().equals(nodeName)) continue;
            nodesToRemove.add(node);
        }
        appliedList.removeAll(nodesToRemove);
        return appliedList;
    }

    private Collection<TemplateTreeNode> getNodesFromSelector(ChildSelectorImpl childSelector, Collection<TemplateTreeNode> appliedList, int depth) {
        String nodeKey = childSelector.getSimpleSelector().toString();
        ArrayList<TemplateTreeNode> nodesToRemove = new ArrayList<TemplateTreeNode>();
        for (TemplateTreeNode node : appliedList) {
            TemplateTreeNode parentNode = this.getNode(node, depth);
            if (parentNode != null && parentNode.getTemplateNode().getKey().equals(nodeKey)) continue;
            nodesToRemove.add(node);
        }
        appliedList.removeAll(nodesToRemove);
        return appliedList;
    }
}

