/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.template.PolygonDrawingElement;
import at.mrdevelopment.esl.template.PolygonRenderingElement;
import at.mrdevelopment.esl.template.RenderingElement;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.Element;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.image.BorderStyle;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

@TemplateElementType(type=TemplateNode.TRIANGLE)
public class Triangle
extends Element
implements PolygonDrawingElement {
    private final Color color;
    private final Integer border;
    private final Color borderColor;
    private final Boolean fill;
    private final int[] xPositions;
    private final int[] yPositions;
    private final Polygon polygon;
    private PolygonRenderingElement renderingElement;
    private BorderStyle borderStyle;

    public Triangle(Map<String, Option<?>> options) throws OptionException {
        super(options);
        this.color = (Color)options.get(Attribute.COLOR.getKey()).get();
        this.border = (Integer)options.get(Attribute.BORDER.getKey()).get();
        this.borderColor = (Color)options.get(Attribute.BORDER_COLOR.getKey()).get();
        this.borderStyle = (BorderStyle)options.get(Attribute.BORDER_STYLE.getKey()).get();
        this.fill = (Boolean)options.get(Attribute.FILL.getKey()).get();
        int x1 = (Integer)options.get(Attribute.X1.getKey()).get();
        int x2 = (Integer)options.get(Attribute.X2.getKey()).get();
        int x3 = (Integer)options.get(Attribute.X3.getKey()).get();
        int y1 = (Integer)options.get(Attribute.Y1.getKey()).get();
        int y2 = (Integer)options.get(Attribute.Y2.getKey()).get();
        int y3 = (Integer)options.get(Attribute.Y3.getKey()).get();
        this.xPositions = new int[]{x1, x2, x3};
        this.yPositions = new int[]{y1, y2, y3};
        this.polygon = new Polygon(this.xPositions, this.yPositions, 3);
        this.renderingElement = new PolygonRenderingElement(this);
    }

    @Override
    public RenderingElement getRenderingElement() {
        return this.renderingElement;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Rectangle getBounds() {
        return this.polygon.getBounds();
    }

    @Override
    public Polygon getPolygon() {
        return this.polygon;
    }

    public Collection<Attribute> getRequiredAttributes() {
        return Arrays.asList(Attribute.X1, Attribute.Y1, Attribute.X2, Attribute.Y2, Attribute.X3, Attribute.Y3);
    }

    @Override
    public int getBorder() {
        return this.border;
    }

    @Override
    public boolean hasBorder() {
        return this.border > 0;
    }

    @Override
    public Color getBorderColor() {
        return this.borderColor;
    }

    @Override
    public boolean isFilled() {
        return this.fill;
    }

    @Override
    public BorderStyle getBorderStyle() {
        return this.borderStyle;
    }
}

