/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.template.RenderingResult;
import at.mrdevelopment.esl.template.TextField;
import at.mrdevelopment.esl.template.TextRenderingElement;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.RenderingStringElement;
import at.mrdevelopment.toolkit.StringElement;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.text.Const;
import at.mrdevelopment.toolkit.text.SpanImage;
import at.mrdevelopment.toolkit.text.TextLine;
import at.mrdevelopment.toolkit.text.Word;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Map;

public class TextFieldContainer
implements TextRenderingElement {
    private ArrayList<TextField> textFields;
    private boolean condense;
    private Rectangle alignmentBounds;
    private final Map<String, Option<?>> options;

    public TextFieldContainer(Map<String, Option<?>> options) {
        this.options = options;
        this.textFields = new ArrayList();
    }

    public void addTextField(TextField textField) {
        this.textFields.add(textField);
    }

    @Override
    public RenderingResult render(int maxWidth, int maxHeight, boolean verbose) {
        if (this.textFields.size() > 0) {
            boolean hasDifferentFontSize = true;
            Rectangle bounds = null;
            ExecutionStatus status = null;
            BufferedImage image = null;
            this.condense = true;
            boolean successful = true;
            block8: while (hasDifferentFontSize) {
                boolean hasSkippedLines = false;
                successful = true;
                image = ImageUtils.createImage((int)maxWidth, (int)maxHeight, (int)2);
                status = new ExecutionStatus();
                bounds = null;
                int yPos = 0;
                for (int index = 0; index < this.textFields.size(); ++index) {
                    if (maxHeight - yPos > 0) {
                        RenderingResult renderingResult = this.textFields.get(index).render(maxWidth, maxHeight - yPos, verbose);
                        if (this.textFields.get(index).hasSkippedLines()) {
                            block25: {
                                successful = false;
                                hasSkippedLines = true;
                                try {
                                    if (this.textFields.get(index).hasFontSizesRemaining()) {
                                        renderingResult = this.redrawTextFieldWithDifferentFontSizes(this.textFields.get(index), maxWidth, maxHeight - yPos, verbose);
                                    }
                                }
                                catch (OptionException exc) {
                                    successful = false;
                                    if (!verbose) break block25;
                                    status.addElement((ExecutionStatusElement)new ExceptionElement((Exception)((Object)exc)));
                                }
                            }
                            if (renderingResult != null && renderingResult.getBounds() != null && renderingResult.getBounds().height + yPos > maxHeight && verbose) {
                                this.addSkippedLineDueToHeight(status, index, renderingResult.getBounds().height, maxHeight - yPos);
                            }
                        }
                        successful = !renderingResult.isSuccessful() ? false : successful;
                        Rectangle newBounds = null;
                        if (bounds == null) {
                            this.alignmentBounds = this.textFields.get(index).getAlignmentBounds();
                            newBounds = bounds = this.appendImage(image, renderingResult.getImage(), yPos, renderingResult.getBounds(), maxWidth, status);
                        } else {
                            newBounds = this.appendImage(image, renderingResult.getImage(), yPos, renderingResult.getBounds(), maxWidth, status);
                            this.addAlignmentBounds(this.textFields.get(index).getAlignmentBounds());
                            if (newBounds != null) {
                                bounds.add(newBounds);
                            }
                        }
                        if (bounds != null && !bounds.isEmpty() && newBounds != null && !newBounds.isEmpty()) {
                            yPos = bounds.height;
                        }
                        if (verbose) {
                            for (ExecutionStatusElement element : renderingResult.getStatus().getElements()) {
                                status.addElement(element);
                            }
                        }
                        if (this.textFields.get(index).hasSkippedLines()) {
                            successful = false;
                            if (verbose) {
                                this.addSkippedLines(status, index, this.textFields.get(index).getSkippedLines());
                            }
                        }
                        if (index != this.textFields.size() - 1) continue;
                        try {
                            hasDifferentFontSize = hasSkippedLines ? this.checkAndChangeFontSize(hasDifferentFontSize) : false;
                        }
                        catch (OptionException exc) {
                            if (verbose) {
                                status.addElement((ExecutionStatusElement)new ExceptionElement((Exception)((Object)exc)));
                            }
                            hasDifferentFontSize = false;
                        }
                        continue;
                    }
                    try {
                        hasDifferentFontSize = this.checkAndChangeFontSize(hasDifferentFontSize);
                        if (!hasDifferentFontSize) continue;
                        continue block8;
                    }
                    catch (OptionException exc) {
                        successful = false;
                        if (!verbose) continue;
                        status.addElement((ExecutionStatusElement)new ExceptionElement((Exception)((Object)exc)));
                    }
                }
            }
            if (image != null && bounds != null && !bounds.isEmpty()) {
                image = ImageUtils.clipToUsedSize((BufferedImage)image, (Rectangle)bounds, (int)maxWidth, (int)maxHeight);
            }
            return new RenderingResult(image, status, bounds, successful);
        }
        ExecutionStatus status = new ExecutionStatus();
        status.addElement((ExecutionStatusElement)new RenderingStringElement(String.format("Textfield is empty (max. width: %d, max. height: %d)", maxWidth, maxHeight), ExecutionStatusElement.ErrorLevel.WARNING));
        BufferedImage image = ImageUtils.createImage((int)maxWidth, (int)maxHeight, (int)2);
        int height = 0;
        try {
            height = this.estimateHeight(image);
        }
        catch (OptionException exc) {
            height = maxHeight;
        }
        return new RenderingResult(ImageUtils.createImage((int)maxWidth, (int)(height <= maxHeight ? height : maxHeight), (int)2), status, false);
    }

    private int estimateHeight(BufferedImage image) throws OptionException {
        TextLine textLine = new TextLine();
        textLine.addWord(Word.delimiterWord(this.options));
        return textLine.getLineHeight(image.createGraphics());
    }

    private RenderingResult redrawTextFieldWithDifferentFontSizes(TextField textField, int maxWidth, int maxHeight, boolean verbose) throws OptionException {
        RenderingResult renderingResult = null;
        boolean fontSizeChanged = true;
        while (fontSizeChanged && textField.hasSkippedLines()) {
            fontSizeChanged = textField.changeMinimumFontSize();
            renderingResult = textField.render(maxWidth, maxHeight, verbose);
        }
        return renderingResult;
    }

    private void addAlignmentBounds(Rectangle currentBounds) {
        if (this.alignmentBounds != null) {
            this.alignmentBounds.width = Math.max(this.alignmentBounds.x, currentBounds.x);
            this.alignmentBounds.height += currentBounds.height;
        }
    }

    private void addSkippedLineDueToHeight(ExecutionStatus status, int index, int height, int maxHeight) {
        String message = String.format("The text '%s' could not be drawn correctly, due to insufficient height (height: %d, remaining height: %d)", this.textFields.get(index).getText(), height, maxHeight);
        status.addElement((ExecutionStatusElement)new StringElement(message, ExecutionStatusElement.ErrorLevel.ERROR));
    }

    private void addSkippedLines(ExecutionStatus status, int index, Map<Integer, String> skippedLines) {
        for (Integer lineNumber : skippedLines.keySet()) {
            String message = String.format("The text line number %d ('%s') in text field number %d could not be drawn correctly", lineNumber, skippedLines.get(lineNumber), index + 1);
            status.addElement((ExecutionStatusElement)new StringElement(message, ExecutionStatusElement.ErrorLevel.ERROR));
        }
    }

    private boolean checkAndChangeFontSize(boolean hasDifferentFontSize) throws OptionException {
        int[] indices = new int[this.textFields.size()];
        for (int i = 0; i < this.textFields.size(); ++i) {
            indices[i] = i;
        }
        return this.checkAndChangeFontSize(hasDifferentFontSize, indices);
    }

    private boolean checkAndChangeFontSize(boolean hasDifferentFontSize, int[] indices) throws OptionException {
        boolean fontChanged = this.changeFontSize(indices);
        if (fontChanged && !this.condense) {
            this.resetCondensingSteps();
            this.condense = true;
            return fontChanged || this.condense;
        }
        if (!fontChanged && this.condense) {
            boolean changed = fontChanged || this.condense;
            this.condense = false;
            return changed;
        }
        return fontChanged;
    }

    private void resetCondensingSteps() {
        for (TextField textField : this.textFields) {
            textField.resetCondensed();
        }
    }

    private boolean changeFontSize(int[] indices) throws OptionException {
        boolean fontSizeChanged = false;
        for (int index : indices) {
            boolean changed = this.textFields.get(index).changeMinimumFontSize();
            fontSizeChanged = changed ? changed : fontSizeChanged;
        }
        return fontSizeChanged;
    }

    private Rectangle appendImage(BufferedImage image, BufferedImage nextImage, int yPos, Rectangle bounds, int maxWidth, ExecutionStatus status) {
        if (bounds != null && !bounds.isEmpty()) {
            if (nextImage.getHeight() > image.getHeight() - yPos || bounds.x + nextImage.getWidth() > maxWidth) {
                int remainingMaxHeight = image.getHeight() - yPos;
                if (remainingMaxHeight == 0) {
                    return null;
                }
                nextImage = SpanImage.clipIfNecessary((BufferedImage)nextImage, (Rectangle)new Rectangle(bounds.width, bounds.height), (int)(maxWidth - bounds.x), (int)(image.getHeight() - yPos), null);
            }
            if (image.getWidth() >= nextImage.getWidth() + bounds.x && image.getHeight() >= nextImage.getHeight() + yPos) {
                ImageUtils.overlayAt((BufferedImage)image, (BufferedImage)nextImage, (int)bounds.x, (int)yPos);
                return new Rectangle(0, yPos, maxWidth, nextImage.getHeight());
            }
        }
        return bounds;
    }

    @Override
    public Rectangle getAlignmentBounds() {
        return this.alignmentBounds;
    }

    public String getText() {
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < this.textFields.size(); ++index) {
            builder.append(this.textFields.get(index).getText());
            if (index >= this.textFields.size() - 1) continue;
            builder.append(Const.NEWLINE);
        }
        return builder.toString();
    }
}

