/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.template.RenderingElement;
import at.mrdevelopment.esl.template.RenderingResult;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.StringElement;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.Element;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.text.Alignment;
import at.mrdevelopment.toolkit.text.LineWrap;
import at.mrdevelopment.toolkit.text.RootSpan;
import at.mrdevelopment.toolkit.text.SpanImage;
import at.mrdevelopment.toolkit.text.TextElement;
import at.mrdevelopment.toolkit.text.Word;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

@TemplateElementType(type=TemplateNode.TEXT)
public class TextField
extends Element
implements RenderingElement {
    public static final String TYPE = "text";
    public static final String SPAN = "span";
    public static final String BR = "br";
    public static final String UL = "ul";
    public static final Object OL = "ol";
    public static final Object LI = "li";
    public static final String ALIGN = "align";
    protected RootSpan span = null;
    protected Alignment alignment = Alignment.LEFT;
    protected SpanImage spanImage;
    private boolean condense = false;
    private LineWrap lineWrap = LineWrap.NORMAL;

    public TextField(Map<String, Option<?>> options, int height) throws OptionException {
        super(options);
        this.span = new RootSpan(options, height);
        this.alignment = (Alignment)options.get(Attribute.ALIGNMENT.getKey()).get();
        this.lineWrap = (LineWrap)options.get(Attribute.WRAP.getKey()).get();
    }

    public TextField(Map<String, Option<?>> options, int height, Class<? extends Element> elementClass, LineWrap lineWrap) throws OptionException {
        super(options, elementClass);
        this.span = new RootSpan(options, height, elementClass);
        this.alignment = (Alignment)options.get(Attribute.ALIGNMENT.getKey()).get();
        this.lineWrap = lineWrap;
    }

    public Collection<Attribute> getRequiredAttributes() {
        return Collections.emptyList();
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public void addTextElement(TextElement textElement) throws OptionException {
        this.span.addTextElement(textElement);
    }

    public boolean isEmpty() {
        return this.span.getText() == null || this.span.getText().isEmpty();
    }

    protected void createSpanImage(int maxWidth, int maxHeight, boolean verbose) {
        this.spanImage = new SpanImage(this.span, maxWidth, maxHeight, this.alignment, verbose);
    }

    @Override
    public RenderingResult render(int maxWidth, int maxHeight, boolean verbose) {
        boolean successful = true;
        this.createSpanImage(maxWidth, maxHeight, verbose);
        Rectangle bounds = this.spanImage.getContentBounds();
        BufferedImage resultingImage = null;
        if (bounds == null || bounds.isEmpty()) {
            successful = false;
            resultingImage = null;
            if (this.span.getText().isEmpty() && verbose) {
                this.spanImage.getExecutionStatus().addElement((ExecutionStatusElement)new StringElement(String.format("Textfield is empty (max. width: %d, max. height: %d)", maxWidth, maxHeight), ExecutionStatusElement.ErrorLevel.WARNING));
            }
        } else {
            resultingImage = this.spanImage.getBufferedImage();
        }
        ExecutionStatus status = this.spanImage.getExecutionStatus();
        successful = !this.spanImage.isSuccessful() ? false : successful;
        RenderingResult result = new RenderingResult(resultingImage, status, bounds, successful);
        return result;
    }

    public boolean hasSkippedLines() {
        return this.spanImage != null ? this.spanImage.hasSkippedLines() : false;
    }

    public Map<Integer, String> getSkippedLines() {
        return this.spanImage != null ? this.spanImage.getSkippedLines() : new HashMap();
    }

    public boolean isWidthResetted() {
        return this.spanImage != null ? this.spanImage.isWidthResetted() : false;
    }

    public int getWidthBeforeReset() {
        return this.spanImage != null ? this.spanImage.getWidthBeforeReset() : 0;
    }

    public boolean changeMinimumFontSize() throws OptionException {
        boolean fontSizeChanged = false;
        for (TextElement textElement : this.span.getTextElements()) {
            boolean currentFontChanged = textElement.nextMinimumFontSize();
            fontSizeChanged = currentFontChanged ? currentFontChanged : fontSizeChanged;
        }
        return fontSizeChanged;
    }

    public boolean wasLastChangeCondense() {
        return this.condense;
    }

    public boolean hasMultipleLines() {
        return this.spanImage != null ? this.spanImage.hasMultipleLines() : false;
    }

    public Collection<Word> getWrappedLineWords() {
        return this.spanImage != null ? this.spanImage.getMultipleLineWords() : new HashSet();
    }

    public String getText() {
        StringBuilder builder = new StringBuilder();
        for (Word word : this.span.getLeaves()) {
            builder.append(word.getText());
        }
        return builder.toString();
    }

    public boolean isCondenseEnabled() throws OptionException {
        for (Word word : this.span.getLeaves()) {
            if (!word.isCondenseEnabled()) continue;
            return true;
        }
        return false;
    }

    public Rectangle getAlignmentBounds() {
        if (this.spanImage != null) {
            return this.spanImage.getAlignmentBounds() != null ? this.spanImage.getAlignmentBounds() : this.spanImage.getContentBounds();
        }
        return null;
    }

    public void resetCondensed() {
        for (Word textElement : this.span.getLeaves()) {
            textElement.resetCondensed();
        }
    }

    public boolean hasFontSizesRemaining() throws OptionException {
        for (Word word : this.span.getLeaves()) {
            if (!word.hasFontSizesRemaining()) continue;
            return true;
        }
        return false;
    }

    public LineWrap getLineWrap() {
        return this.lineWrap;
    }
}

