/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.template.TemplateUtils;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TemplateUtilsFactory {
    private final Set<TemplateUtils> utils = new HashSet<TemplateUtils>();

    public void registerTemplateUtils(TemplateUtils templateUtils) {
        this.utils.add(templateUtils);
    }

    public void unregisterTemplateUtils(TemplateUtils templateUtils) {
        this.utils.remove(templateUtils);
    }

    public void applyUtils(Element root, ExecutionStatus status) {
        if (root != null) {
            NodeList utilNodeList = root.getElementsByTagName("utils");
            while (utilNodeList.getLength() > 0) {
                Element utilElement = (Element)utilNodeList.item(utilNodeList.getLength() - 1);
                try {
                    String returnValue = this.callMethod(utilElement);
                    if (returnValue != null) {
                        utilElement.getParentNode().replaceChild(root.getOwnerDocument().createTextNode(returnValue), utilElement);
                        continue;
                    }
                    utilElement.getParentNode().replaceChild(root.getOwnerDocument().createTextNode(utilElement.getTextContent()), utilElement);
                }
                catch (Exception exc) {
                    if (status != null) {
                        status.addElement((ExecutionStatusElement)new ExceptionElement(exc));
                    }
                    utilElement.getParentNode().replaceChild(root.getOwnerDocument().createTextNode(utilElement.getTextContent()), utilElement);
                }
            }
        }
    }

    private String callMethod(Element utilElement) throws Exception {
        if (!utilElement.hasAttribute("method")) {
            throw new IllegalArgumentException("No method specified for template utils.");
        }
        String methodString = utilElement.getAttribute("method");
        String parameterString = utilElement.getTextContent();
        List<String> arguments = this.parseArguments(utilElement);
        Method alternativeMethod = null;
        if (parameterString != null && !parameterString.isEmpty()) {
            arguments.add(0, parameterString);
        }
        for (TemplateUtils templateUtils : this.utils) {
            try {
                Method[] methods;
                for (Method method : methods = templateUtils.getClass().getMethods()) {
                    if (method.getName().equals(methodString) && method.getParameterTypes().length == arguments.size()) {
                        String returnObject = method.invoke((Object)templateUtils, arguments.toArray()).toString();
                        return returnObject != null ? returnObject.toString() : null;
                    }
                    if (!method.getName().equals(methodString)) continue;
                    alternativeMethod = method;
                }
            }
            catch (Exception exc) {
                String message = exc.getMessage() != null ? exc.getMessage() : exc.getCause().getMessage();
                throw new Exception("Could not invoke method " + methodString + ". " + message);
            }
        }
        if (alternativeMethod != null) {
            throw new IllegalArgumentException(String.format("The method %s takes %d parameter(s) and is not applicable with %d parameter(s)", methodString, alternativeMethod.getParameterTypes().length, arguments.size()));
        }
        throw new IllegalArgumentException("Method " + methodString + " not found");
    }

    private List<String> parseArguments(Element utilElement) {
        boolean hasFurtherArguments = true;
        int argNumber = 1;
        ArrayList<String> arguments = new ArrayList<String>();
        while (hasFurtherArguments) {
            String argumentName = "arg" + String.valueOf(argNumber);
            if (utilElement.hasAttribute(argumentName)) {
                arguments.add(utilElement.getAttribute(argumentName));
                ++argNumber;
                continue;
            }
            hasFurtherArguments = false;
        }
        return arguments;
    }
}

