/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import java.util.LinkedList;
import java.util.Map;
import org.w3c.dom.Node;

public class TemplateTreeNode {
    private final TemplateTreeNode parent;
    private final TemplateNode node;
    private final Map<String, Option<?>> options;
    private LinkedList<TemplateTreeNode> childs = new LinkedList();
    private final Node nodeElement;
    private final String path;

    public TemplateTreeNode(TemplateNode node, Map<String, Option<?>> options, TemplateTreeNode parent, Node nodeElement) {
        this.node = node;
        this.options = options;
        this.parent = parent;
        this.nodeElement = nodeElement;
        this.path = parent != null ? parent.getPath() + " " + node.getKey() : node.getKey();
    }

    public String getPath() {
        return this.path;
    }

    public Node getNode() {
        return this.nodeElement;
    }

    public void addChild(TemplateTreeNode child) {
        this.childs.add(child);
    }

    public LinkedList<TemplateTreeNode> getChilds() {
        return this.childs;
    }

    public TemplateNode getTemplateNode() {
        return this.node;
    }

    public Map<String, Option<?>> getOptions() {
        return this.options;
    }

    public TemplateTreeNode getParent() {
        return this.parent;
    }

    public String getCSSClass() throws OptionException {
        return this.options.containsKey(Attribute.CLASS.getKey()) ? this.options.get(Attribute.CLASS.getKey()).getValueAsString() : "";
    }

    public String getId() throws OptionException {
        return this.options.containsKey(Attribute.ID.getKey()) ? this.options.get(Attribute.ID.getKey()).getValueAsString() : "";
    }

    public void propagateOptions() throws OptionException {
        for (Attribute attribute : this.node.getAttributeList()) {
            if (!attribute.isInheritate()) continue;
            Option<?> option = this.options.get(attribute.getKey());
            for (TemplateTreeNode childNode : this.getChilds()) {
                if (!childNode.getOptions().containsKey(option.getKey()) || childNode.getOptions().get(option.getKey()).hasValueChanged() || this.nodeElement.getAttributes().getNamedItem(attribute.getKey()) == null || childNode.getNode().getAttributes().getNamedItem(attribute.getKey()) != null) continue;
                childNode.getOptions().get(option.getKey()).setValueFromString(option.getValueAsString());
            }
        }
        for (TemplateTreeNode childNode : this.getChilds()) {
            childNode.propagateOptions();
        }
    }

    public String toString() {
        int depth = 0;
        TemplateTreeNode node = this;
        while ((node = node.getParent()) != null) {
            ++depth;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            builder.append("\t");
        }
        builder.append(this.getTemplateNode().getKey());
        builder.append(": ");
        builder.append(this.getOptions().toString());
        for (int index = 0; index < this.getChilds().size(); ++index) {
            if (index == 0) {
                builder.append("\n");
            }
            builder.append(this.getChilds().get(index).toString());
            if (index >= this.getChilds().size() - 1) continue;
            builder.append("\n");
        }
        return builder.toString();
    }
}

