/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.template.Rect;
import at.mrdevelopment.esl.template.RenderingElement;
import at.mrdevelopment.esl.template.RenderingResult;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.image.RoundedRectangle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;

public class RectangleRenderingElement
implements RenderingElement {
    private final Rect rectangle;

    public RectangleRenderingElement(Rect rectangle) {
        this.rectangle = rectangle;
    }

    @Override
    public RenderingResult render(int maxWidth, int maxHeight, boolean verbose) {
        ExecutionStatus status = new ExecutionStatus();
        BufferedImage image = ImageUtils.createImage((int)maxWidth, (int)maxHeight, (int)2);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(this.rectangle.getColor());
        if (this.rectangle.getCornerRadius() > 0 && this.rectangle.getRoundedCorners() > 0) {
            RoundedRectangle roundedRectangle = new RoundedRectangle((float)this.rectangle.getBounds().x, (float)this.rectangle.getBounds().y, (float)this.rectangle.getBounds().width, (float)this.rectangle.getBounds().height, (float)this.rectangle.getCornerRadius(), this.rectangle.getRoundedCorners());
            if (this.rectangle.isFilled()) {
                graphics.fill(roundedRectangle.getShape());
            }
            graphics.dispose();
            ImageUtils.drawBorder((BufferedImage)image, (Shape)roundedRectangle.getShape(), (Color)this.rectangle.getBorderColor(), (Stroke)(this.rectangle.hasBorder() ? this.rectangle.getBorderStyle().getStroke(this.rectangle.getBorder()) : new BasicStroke(1.0f)));
        } else {
            if (this.rectangle.isFilled()) {
                graphics.fillRect(this.rectangle.getBounds().x, this.rectangle.getBounds().y, this.rectangle.getBounds().width, this.rectangle.getBounds().height);
                if (this.rectangle.hasBorder()) {
                    ImageUtils.drawBorder((BufferedImage)image, (int)this.rectangle.getBounds().x, (int)this.rectangle.getBounds().y, (int)this.rectangle.getBounds().width, (int)this.rectangle.getBounds().height, (Color)this.rectangle.getBorderColor(), (Stroke)(this.rectangle.hasBorder() ? this.rectangle.getBorderStyle().getStroke(this.rectangle.getBorder()) : new BasicStroke(1.0f)));
                }
            } else {
                ImageUtils.drawBorder((BufferedImage)image, (int)this.rectangle.getBounds().x, (int)this.rectangle.getBounds().y, (int)this.rectangle.getBounds().width, (int)this.rectangle.getBounds().height, (Color)this.rectangle.getBorderColor(), (Stroke)(this.rectangle.hasBorder() ? this.rectangle.getBorderStyle().getStroke(this.rectangle.getBorder()) : new BasicStroke(1.0f)));
            }
            graphics.dispose();
        }
        return new RenderingResult(image, status, this.rectangle.getBounds(), true);
    }
}

