/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.template.DrawingElement;
import at.mrdevelopment.esl.template.RectangleRenderingElement;
import at.mrdevelopment.esl.template.RenderingElement;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.Element;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.image.BorderStyle;
import at.mrdevelopment.toolkit.image.RoundedCorner;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

@TemplateElementType(type=TemplateNode.RECT)
public class Rect
extends Element
implements DrawingElement {
    private final Rectangle bounds;
    private final Color color;
    private RectangleRenderingElement renderingElement;
    private final int border;
    private final boolean fill;
    private final Color borderColor;
    private int cornerRadius;
    private int flags;
    private final BorderStyle borderStyle;

    public Rect(Map<String, Option<?>> options) throws OptionException {
        super(options);
        this.color = (Color)options.get(Attribute.COLOR.getKey()).get();
        this.border = (Integer)options.get(Attribute.BORDER.getKey()).get();
        this.borderColor = (Color)options.get(Attribute.BORDER_COLOR.getKey()).get();
        this.fill = (Boolean)options.get(Attribute.FILL.getKey()).get();
        this.borderStyle = (BorderStyle)options.get(Attribute.BORDER_STYLE.getKey()).get();
        int xPos = (Integer)options.get(Attribute.X.getKey()).get();
        int yPos = (Integer)options.get(Attribute.Y.getKey()).get();
        int width = (Integer)options.get(Attribute.WIDTH.getKey()).get();
        int height = (Integer)options.get(Attribute.HEIGHT.getKey()).get();
        this.cornerRadius = (Integer)options.get(Attribute.CORNER_RADIUS.getKey()).get();
        this.flags = RoundedCorner.calculateFlags((Object[])((Object[])options.get(Attribute.ROUNDED_CORNERS.getKey()).get()));
        this.bounds = new Rectangle(xPos, yPos, width, height);
        this.renderingElement = new RectangleRenderingElement(this);
    }

    public Collection<Attribute> getRequiredAttributes() {
        return Arrays.asList(Attribute.X, Attribute.Y, Attribute.WIDTH, Attribute.HEIGHT);
    }

    @Override
    public RenderingElement getRenderingElement() {
        return this.renderingElement;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public int getBorder() {
        return this.border;
    }

    public boolean hasBorder() {
        return this.border > 0;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public BorderStyle getBorderStyle() {
        return this.borderStyle;
    }

    public boolean isFilled() {
        return this.fill;
    }

    public int getCornerRadius() {
        return this.cornerRadius;
    }

    public int getRoundedCorners() {
        return this.flags;
    }
}

