/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.template.PolygonDrawingElement;
import at.mrdevelopment.esl.template.RenderingElement;
import at.mrdevelopment.esl.template.RenderingResult;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.image.ImageUtils;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class PolygonRenderingElement
implements RenderingElement {
    private final PolygonDrawingElement polygonElement;

    public PolygonRenderingElement(PolygonDrawingElement polygonElement) {
        this.polygonElement = polygonElement;
    }

    @Override
    public RenderingResult render(int maxWidth, int maxHeight, boolean verbose) {
        ExecutionStatus status = new ExecutionStatus();
        BufferedImage image = ImageUtils.createImage((int)maxWidth, (int)maxHeight, (int)2);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(this.polygonElement.getColor());
        if (this.polygonElement.isFilled()) {
            graphics.fillPolygon(this.polygonElement.getPolygon());
        }
        graphics.setColor(this.polygonElement.getBorderColor());
        graphics.setStroke(this.polygonElement.hasBorder() ? this.polygonElement.getBorderStyle().getStroke(this.polygonElement.getBorder()) : new BasicStroke(1.0f));
        graphics.drawPolygon(this.polygonElement.getPolygon());
        graphics.dispose();
        return new RenderingResult(image, status, this.polygonElement.getBounds(), true);
    }
}

