/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.template.DrawingElement;
import at.mrdevelopment.esl.template.LineRenderingElement;
import at.mrdevelopment.esl.template.RenderingElement;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.Element;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

@TemplateElementType(type=TemplateNode.LINE)
public class Line
extends Element
implements DrawingElement {
    private final Rectangle bounds;
    private final int xFrom;
    private final int yFrom;
    private final int xTo;
    private final int yTo;
    private final int thickness;
    private final Color color;
    private final RenderingElement renderingElement;

    public Line(Map<String, Option<?>> options) throws OptionException {
        super(options);
        this.xFrom = (Integer)options.get(Attribute.X_FROM.getKey()).get();
        this.yFrom = (Integer)options.get(Attribute.Y_FROM.getKey()).get();
        this.xTo = (Integer)options.get(Attribute.X_TO.getKey()).get();
        this.yTo = (Integer)options.get(Attribute.Y_TO.getKey()).get();
        this.thickness = (Integer)options.get(Attribute.THICKNESS.getKey()).get();
        this.color = (Color)options.get(Attribute.COLOR.getKey()).get();
        this.renderingElement = new LineRenderingElement(this);
        this.bounds = new Line2D.Double(this.xFrom, this.yFrom, this.xTo, this.yTo).getBounds();
        if (this.bounds.height == 0) {
            this.bounds.height = this.thickness;
        }
    }

    public Collection<Attribute> getRequiredAttributes() {
        return Arrays.asList(Attribute.X_FROM, Attribute.X_TO, Attribute.Y_FROM, Attribute.Y_TO);
    }

    @Override
    public RenderingElement getRenderingElement() {
        return this.renderingElement;
    }

    public int getXFrom() {
        return this.xFrom;
    }

    public int getYFrom() {
        return this.yFrom;
    }

    public int getXTo() {
        return this.xTo;
    }

    public int getYTo() {
        return this.yTo;
    }

    public int getThickness() {
        return this.thickness;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }
}

