/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.template.DrawingElement;
import at.mrdevelopment.esl.template.Field;
import at.mrdevelopment.esl.template.TemplateTree;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ImageTemplate {
    private final File backgroundImageFile;
    private final int width;
    private final int height;
    private final List<Field> fields;
    private final Color backgroundColor;
    private final int rotation;
    private final List<DrawingElement> drawingElements;
    private final boolean inverted;
    private final Rectangle clippingRegion;
    private final boolean useColors;
    private TemplateTree templateTree;
    private final boolean ditheringEnabled;

    public ImageTemplate(TemplateTree templateTree, Color backgroundColor, File backgroundImageFile, int width, int height, int rotation, Rectangle clippingRegion, boolean inverted, boolean useColors, boolean ditheringEnabled, List<Field> fields, List<DrawingElement> drawingElements) {
        this.templateTree = templateTree;
        this.backgroundColor = backgroundColor;
        this.backgroundImageFile = backgroundImageFile;
        this.width = width;
        this.height = height;
        this.rotation = rotation;
        this.clippingRegion = clippingRegion;
        this.inverted = inverted;
        this.useColors = useColors;
        this.ditheringEnabled = ditheringEnabled;
        this.drawingElements = new ArrayList<DrawingElement>(drawingElements);
        this.fields = new ArrayList<Field>(fields);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public boolean hasBackgroundImage() {
        return this.backgroundImageFile != null;
    }

    public File getBackgroundImage() {
        return this.backgroundImageFile;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean hasRotation() {
        return this.rotation == 90 || this.rotation == 180 || this.rotation == 270;
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public List<Field> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public List<DrawingElement> getDrawingElements() {
        return Collections.unmodifiableList(this.drawingElements);
    }

    public Rectangle getClippingRegion() {
        return this.clippingRegion;
    }

    public boolean hasClippingRegion() {
        return this.clippingRegion != null;
    }

    public boolean isUseColors() {
        return this.useColors;
    }

    public TemplateTree getTemplateTree() {
        return this.templateTree;
    }

    public boolean isDitheringEnabled() {
        return this.ditheringEnabled;
    }
}

