/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.template.RenderingElement;
import at.mrdevelopment.esl.template.RenderingResult;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.StringElement;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.Element;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.image.ImageSerializer;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

@TemplateElementType(type=TemplateNode.IMAGE)
public class ImageField
extends Element
implements RenderingElement {
    public static final String TYPE = "img";
    private final String imageSource;
    private final String data;
    private final File workingDirectory;
    private final boolean autoScale;
    private final Insets cutInsets;

    public ImageField(Map<String, Option<?>> options, File workingDirectory) throws OptionException {
        super(options);
        this.workingDirectory = workingDirectory;
        this.imageSource = (String)options.get(Attribute.SOURCE.getKey()).get();
        this.data = (String)options.get(Attribute.DATA.getKey()).get();
        this.autoScale = (Boolean)options.get(Attribute.AUTOSCALE.getKey()).get();
        int cutLeft = options.containsKey(Attribute.CUT_LEFT.getKey()) ? (Integer)options.get(Attribute.CUT_LEFT.getKey()).get() : 0;
        int cutRight = options.containsKey(Attribute.CUT_RIGHT.getKey()) ? (Integer)options.get(Attribute.CUT_RIGHT.getKey()).get() : 0;
        int cutTop = options.containsKey(Attribute.CUT_TOP.getKey()) ? (Integer)options.get(Attribute.CUT_TOP.getKey()).get() : 0;
        int cutBottom = options.containsKey(Attribute.CUT_BOTTOM.getKey()) ? (Integer)options.get(Attribute.CUT_BOTTOM.getKey()).get() : 0;
        this.cutInsets = new Insets(cutTop, cutLeft, cutBottom, cutRight);
        if (this.data == null && this.imageSource == null) {
            throw new OptionException(String.format("One of the following attributes has to be specified: %s or %s", Attribute.SOURCE.getKey(), Attribute.DATA.getKey()));
        }
    }

    public Collection<Attribute> getRequiredAttributes() {
        return Collections.emptyList();
    }

    public File getImageFile() {
        if (this.imageSource != null) {
            return new File(this.workingDirectory, this.imageSource);
        }
        return null;
    }

    public String getData() {
        return this.data;
    }

    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    @Override
    public RenderingResult render(int maxWidth, int maxHeight, boolean verbose) {
        boolean successful;
        ExecutionStatus status;
        BufferedImage image;
        block13: {
            image = null;
            status = new ExecutionStatus();
            successful = true;
            if (this.hasData()) {
                try {
                    image = this.loadImageFromData(status);
                }
                catch (SerializeException exc) {
                    successful = false;
                    if (verbose) {
                        status.addElement((ExecutionStatusElement)new StringElement("Could not load image.", ExecutionStatusElement.ErrorLevel.ERROR));
                        status.addElement((ExecutionStatusElement)new ExceptionElement((Exception)((Object)exc)));
                    }
                    break block13;
                }
            }
            try {
                image = ImageUtils.loadImageSource((File)this.workingDirectory, (String)this.imageSource);
            }
            catch (Exception exc) {
                successful = false;
                if (!verbose) break block13;
                status.addElement((ExecutionStatusElement)new StringElement("Could not load image.", ExecutionStatusElement.ErrorLevel.ERROR));
                if (exc.getMessage() == null) break block13;
                status.addElement((ExecutionStatusElement)new ExceptionElement(exc));
            }
        }
        if (image != null) {
            if (this.cutInsets.bottom > 0 || this.cutInsets.left > 0 || this.cutInsets.right > 0 || this.cutInsets.top > 0) {
                image = ImageUtils.clip((BufferedImage)image, (Rectangle)new Rectangle(this.cutInsets.left, this.cutInsets.top, image.getWidth() - this.cutInsets.left - this.cutInsets.right, image.getHeight() - this.cutInsets.top - this.cutInsets.bottom));
            }
            if (this.autoScale) {
                image = ImageUtils.scaleToFit((BufferedImage)image, (int)maxWidth, (int)maxHeight);
            } else {
                if (image.getWidth() > maxWidth) {
                    image = ImageUtils.clip((BufferedImage)image, (Rectangle)new Rectangle(0, 0, maxWidth, image.getHeight()));
                }
                if (image.getHeight() > maxHeight) {
                    image = ImageUtils.clip((BufferedImage)image, (Rectangle)new Rectangle(0, 0, image.getWidth(), maxHeight));
                }
            }
        } else {
            image = ImageUtils.createImage((int)maxWidth, (int)maxHeight, (int)12);
        }
        return new RenderingResult(image, status, successful);
    }

    private BufferedImage loadImageFromData(ExecutionStatus status) throws SerializeException {
        return ImageSerializer.fromBase64String((String)this.data);
    }
}

